/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.screen;

import java.util.List;
import javax.annotation.Nonnull;
import kandango.reagenica.ChemiUtils;
import kandango.reagenica.ChemistryMod;
import kandango.reagenica.block.entity.BlastFurnaceBlockEntity;
import kandango.reagenica.screen.ChemistryMenu;
import kandango.reagenica.screen.ModMenus;
import kandango.reagenica.screen.slots.SlotPriorityRule;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class BlastFurnaceMenu
extends ChemistryMenu<BlastFurnaceBlockEntity> {
    public BlastFurnaceMenu(int id, Inventory inv, FriendlyByteBuf extradata) {
        this(id, inv, (BlastFurnaceBlockEntity)inv.f_35978_.m_9236_().m_7702_(extradata.m_130135_()));
    }

    public BlastFurnaceMenu(int id, Inventory inv, final BlastFurnaceBlockEntity be) {
        super((MenuType)ModMenus.BLAST_FURNACE_MENU.get(), id, inv, be);
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.getTemp();
            }

            public void m_6422_(int value) {
                be.setTemp(value);
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.getFuel();
            }

            public void m_6422_(int value) {
                be.setFuel(value);
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.getFuelMax();
            }

            public void m_6422_(int value) {
                be.setFuelMax(value);
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.getProgress() & 0xFFFF;
            }

            public void m_6422_(int value) {
                be.setProgress(be.getProgress() & 0xFFFF0000 | value & 0xFFFF);
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.getProgress() >> 16 & 0xFFFF;
            }

            public void m_6422_(int value) {
                be.setProgress(be.getProgress() & 0xFFFF | (value & 0xFFFF) << 16);
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.getmaxTemp();
            }

            public void m_6422_(int value) {
                be.setmaxTemp(value);
            }
        });
    }

    public int getTemp() {
        return ChemiUtils.nonNullOrLog((BlastFurnaceBlockEntity)this.blockEntity).map(x -> x.getTemp()).orElse(0);
    }

    public int getBurnTime() {
        return ChemiUtils.nonNullOrLog((BlastFurnaceBlockEntity)this.blockEntity).map(x -> x.getFuel()).orElse(0);
    }

    public int getMaxBurnTime() {
        return ChemiUtils.nonNullOrLog((BlastFurnaceBlockEntity)this.blockEntity).map(x -> x.getFuelMax()).orElse(0);
    }

    public int getProgress() {
        return ChemiUtils.nonNullOrLog((BlastFurnaceBlockEntity)this.blockEntity).map(x -> x.getProgress()).orElse(0);
    }

    public double getSliderValue() {
        return ChemiUtils.nonNullOrLog((BlastFurnaceBlockEntity)this.blockEntity).map(x -> x.getSliderValue()).orElse(0.0);
    }

    @Override
    public List<SlotPriorityRule> quickMoveRules() {
        List<SlotPriorityRule> rules = List.of(SlotPriorityRule.single(stack -> stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("minecraft", "coals"))), 1));
        return rules;
    }

    @Override
    protected void internalSlots(BlastFurnaceBlockEntity be) {
        ItemStackHandler handler = be.getItemHandler();
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 0, 56, 23));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 1, 56, 59));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 2, 116, 24){

            public void m_142406_(@Nonnull Player player, @Nonnull ItemStack stack) {
                super.m_142406_(player, stack);
                if (!player.m_9236_().f_46443_) {
                    BlastFurnaceMenu.this.awardExp(player);
                }
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 3, 116, 48));
    }

    @Override
    protected ItemStack quickMoveStackFunc(int slotcount, @Nonnull Player player, int index, List<SlotPriorityRule> rules) {
        if (index == 2 && !player.m_9236_().f_46443_) {
            this.awardExp(player);
        }
        return super.quickMoveStackFunc(slotcount, player, index, rules);
    }

    @Override
    protected int slotCount() {
        return 4;
    }

    private void awardExp(Player pl) {
        BlastFurnaceBlockEntity be = (BlastFurnaceBlockEntity)this.blockEntity;
        if (be == null) {
            ChemistryMod.LOGGER.warn("Tried to get Experience while Blockentity was null!");
        } else {
            be.awardExp(pl);
        }
    }
}

