/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.screen;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.screen.slots.SlotPriorityRule;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class ChemistryMenu<T extends BlockEntity>
extends AbstractContainerMenu {
    @Nullable
    protected T blockEntity;

    public ChemistryMenu(MenuType<?> type, int id, Inventory inv, T be) {
        super(type, id);
        this.blockEntity = be;
        this.initSlots(inv, be);
    }

    public boolean m_6875_(@Nonnull Player player) {
        T be = this.blockEntity;
        if (be != null) {
            Level level = be.m_58904_();
            return level != null && level.m_8055_(be.m_58899_()).m_60734_() == be.m_58900_().m_60734_() && player.m_20275_((double)be.m_58899_().m_123341_() + 0.5, (double)be.m_58899_().m_123342_() + 0.5, (double)be.m_58899_().m_123343_() + 0.5) <= 64.0;
        }
        return false;
    }

    private void initSlots(Inventory inv, T be) {
        this.internalSlots(be);
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)inv, col + row * 9 + 9, 8 + col * 18, this.inv_start() + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)inv, col, 8 + col * 18, this.hotbar_start()));
        }
    }

    protected abstract void internalSlots(T var1);

    public T getBlockEntity() {
        return this.blockEntity;
    }

    protected abstract int slotCount();

    public final ItemStack m_7648_(@Nonnull Player player, int index) {
        return this.quickMoveStackFunc(this.slotCount(), player, index, this.quickMoveRules());
    }

    protected List<SlotPriorityRule> quickMoveRules() {
        return List.of();
    }

    protected ItemStack quickMoveStackFunc(int slotcount, @Nonnull Player player, int index, List<SlotPriorityRule> rules) {
        ItemStack originalStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            int playerInventoryEnd;
            int containerSlotCount;
            ItemStack currentStack = slot.m_7993_();
            originalStack = currentStack.m_41777_();
            int playerInventoryStart = containerSlotCount = slotcount;
            int hotbarStart = playerInventoryEnd = playerInventoryStart + 27;
            int hotbarEnd = hotbarStart + 9;
            if (index < containerSlotCount) {
                if (!this.m_38903_(currentStack, playerInventoryStart, hotbarEnd, true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                SlotPriorityRule rule;
                boolean moved = false;
                Iterator<SlotPriorityRule> iterator = rules.iterator();
                while (!(!iterator.hasNext() || (rule = iterator.next()).matcher().test(currentStack) && (moved = this.m_38903_(currentStack, rule.startSlot(), rule.endSlot(), false)))) {
                }
                if (!moved && !this.m_38903_(currentStack, 0, containerSlotCount, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (currentStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return originalStack;
    }

    protected int inv_start() {
        return 84;
    }

    protected int hotbar_start() {
        return this.inv_start() + 58;
    }
}

