/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.screen;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import kandango.reagenica.ChemistryMod;
import kandango.reagenica.block.entity.util.ItemStackUtil;
import kandango.reagenica.recipes.ReagenimartRecipe;
import kandango.reagenica.screen.ModMenus;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ComputerMenu
extends AbstractContainerMenu {
    private final Container insideSlot = new SimpleContainer(2);
    private ReagenimartRecipe selected = null;
    private final Map<ReagenimartRecipe.ReagenimartCategory, List<ReagenimartRecipe>> trades;
    private final Level level;

    public ComputerMenu(int id, Inventory playerInv) {
        super((MenuType)ModMenus.COMPUTER_MENU.get(), id);
        this.m_38897_(new Slot(this.insideSlot, 0, 105, 66){

            public void m_6654_() {
                super.m_6654_();
                ComputerMenu.this.updateResultSlot();
            }
        });
        this.m_38897_(new Slot(this.insideSlot, 1, 144, 66){

            public boolean m_5857_(@Nonnull ItemStack stack) {
                return false;
            }

            public void m_142406_(@Nonnull Player player, @Nonnull ItemStack stack) {
                super.m_142406_(player, stack);
                if (!player.m_9236_().f_46443_) {
                    ComputerMenu.this.buy();
                }
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 110 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, 168));
        }
        this.level = playerInv.f_35978_.m_9236_();
        if (this.level == null) {
            throw new IllegalStateException("Player Level was null");
        }
        this.trades = Map.of(ReagenimartRecipe.ReagenimartCategory.BUILDING, ReagenimartRecipe.getRecipeCategorized(this.level, ReagenimartRecipe.ReagenimartCategory.BUILDING), ReagenimartRecipe.ReagenimartCategory.COMMODITY, ReagenimartRecipe.getRecipeCategorized(this.level, ReagenimartRecipe.ReagenimartCategory.COMMODITY), ReagenimartRecipe.ReagenimartCategory.MINERALS, ReagenimartRecipe.getRecipeCategorized(this.level, ReagenimartRecipe.ReagenimartCategory.MINERALS), ReagenimartRecipe.ReagenimartCategory.NATURALS, ReagenimartRecipe.getRecipeCategorized(this.level, ReagenimartRecipe.ReagenimartCategory.NATURALS));
    }

    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
        this.m_150411_(player, (Container)new SimpleContainer(new ItemStack[]{this.insideSlot.m_8020_(0)}));
    }

    public ItemStack m_7648_(@Nonnull Player player, int index) {
        if (this.level.f_46443_) {
            return ItemStack.f_41583_;
        }
        ItemStack originalStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack currentStack = slot.m_7993_();
            originalStack = currentStack.m_41777_();
            int containerSlotCount = 2;
            int playerInventoryStart = 2;
            int playerInventoryEnd = 29;
            int hotbarStart = 29;
            int hotbarEnd = 38;
            if (index < 2) {
                if (index == 1) {
                    ItemStack result;
                    while (ItemStackUtil.isEnough(this.insideSlot.m_8020_(0), this.selected.getPrice()) && this.m_38903_(result = this.selected.getMerchandise().m_41777_(), 2, this.f_38839_.size(), true)) {
                        this.buy();
                    }
                    currentStack = ItemStack.f_41583_;
                }
                if (!this.m_38903_(currentStack, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (!this.m_38903_(currentStack, 0, 2, false)) {
                return ItemStack.f_41583_;
            }
            if (currentStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return originalStack;
    }

    public boolean m_6875_(@Nonnull Player player) {
        return true;
    }

    private boolean buy() {
        if (this.selected == null) {
            ChemistryMod.LOGGER.error("Selected merchandise was null when buying: ", (Throwable)new IllegalStateException());
            return false;
        }
        ItemStack payment = this.insideSlot.m_8020_(0).m_41777_();
        if (!ItemStackUtil.isEnough(payment, this.selected.getPrice())) {
            return false;
        }
        payment.m_41774_(this.selected.getPrice().m_41613_());
        this.insideSlot.m_6836_(0, payment);
        this.updateResultSlot();
        return true;
    }

    public List<ReagenimartRecipe> recipes(ReagenimartRecipe.ReagenimartCategory cat) {
        return Objects.requireNonNull(this.trades.get((Object)cat));
    }

    public void receiveClickAction(int clickid) {
        if (clickid == -1) {
            this.selected = null;
        } else {
            int index = clickid & 0xFFFF;
            try {
                ReagenimartRecipe.ReagenimartCategory cat = ReagenimartRecipe.ReagenimartCategory.values()[clickid >> 16];
                this.selected = this.recipes(cat).get(index);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                ChemistryMod.LOGGER.warn("Invalid trade id category packet recieved," + clickid, (Throwable)new SecurityException());
            }
            catch (IndexOutOfBoundsException e) {
                ChemistryMod.LOGGER.warn("Invalid trade id index packet recieved," + clickid, (Throwable)new SecurityException());
            }
        }
        this.updateResultSlot();
    }

    private void updateResultSlot() {
        if (this.selected == null) {
            this.insideSlot.m_6836_(1, ItemStack.f_41583_);
        } else if (this.selected.isValidPayment(this.insideSlot.m_8020_(0))) {
            this.insideSlot.m_6836_(1, this.selected.getMerchandise().m_41777_());
        } else {
            this.insideSlot.m_6836_(1, ItemStack.f_41583_);
        }
    }
}

