/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kandango.reagenica.ChemiItems;
import kandango.reagenica.packet.ComputerOrderPacket;
import kandango.reagenica.packet.ModMessages;
import kandango.reagenica.recipes.ReagenimartRecipe;
import kandango.reagenica.screen.ComputerMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class ComputerScreen
extends AbstractContainerScreen<ComputerMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("reagenica", "textures/gui/container/computer.png");
    private ReagenimartRecipe.ReagenimartCategory currentcat = ReagenimartRecipe.ReagenimartCategory.BUILDING;
    private final Map<ReagenimartRecipe.ReagenimartCategory, ItemStack> catItemMap = Map.of(ReagenimartRecipe.ReagenimartCategory.BUILDING, new ItemStack((ItemLike)Blocks.f_50076_), ReagenimartRecipe.ReagenimartCategory.COMMODITY, new ItemStack((ItemLike)ChemiItems.CHLORINE.get()), ReagenimartRecipe.ReagenimartCategory.MINERALS, new ItemStack((ItemLike)Items.f_151053_), ReagenimartRecipe.ReagenimartCategory.NATURALS, new ItemStack((ItemLike)Items.f_41941_));
    private int currentselectedIndex = -1;
    private int currentScroll = 0;

    public ComputerScreen(ComputerMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.f_97727_ = 191;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7286_(@Nonnull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int itemIndex;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        graphics.m_280203_(this.catItemMap.get((Object)ReagenimartRecipe.ReagenimartCategory.BUILDING), this.f_97735_ + 6, this.f_97736_ + 18);
        graphics.m_280203_(this.catItemMap.get((Object)ReagenimartRecipe.ReagenimartCategory.COMMODITY), this.f_97735_ + 6, this.f_97736_ + 40);
        graphics.m_280203_(this.catItemMap.get((Object)ReagenimartRecipe.ReagenimartCategory.MINERALS), this.f_97735_ + 6, this.f_97736_ + 62);
        graphics.m_280203_(this.catItemMap.get((Object)ReagenimartRecipe.ReagenimartCategory.NATURALS), this.f_97735_ + 6, this.f_97736_ + 84);
        List<ReagenimartRecipe> trades = ((ComputerMenu)this.f_97732_).recipes(this.currentcat);
        for (int i = 0; i < 15 && (itemIndex = this.currentScroll * 3 + i) < trades.size(); ++i) {
            graphics.m_280203_(trades.get(itemIndex).getMerchandise(), this.f_97735_ + 26 + i % 3 * 18, this.f_97736_ + 15 + i / 3 * 18);
        }
        ReagenimartRecipe selectedRecipe = this.getRecipeSelected();
        if (selectedRecipe != null) {
            this.renderFakeItemandCounts(graphics, selectedRecipe.getPrice(), this.f_97735_ + 105, this.f_97736_ + 45);
            this.renderFakeItemandCounts(graphics, selectedRecipe.getMerchandise(), this.f_97735_ + 144, this.f_97736_ + 45);
        }
    }

    private void renderFakeItemandCounts(GuiGraphics graphics, ItemStack stack, int x, int y) {
        graphics.m_280203_(stack, x, y);
        graphics.m_280370_(this.f_96547_, stack, x, y);
    }

    @Nullable
    private ReagenimartRecipe getRecipeSelected() {
        if (this.currentselectedIndex == -1) {
            return null;
        }
        if (this.currentselectedIndex >= ((ComputerMenu)this.f_97732_).recipes(this.currentcat).size()) {
            return null;
        }
        return ((ComputerMenu)this.f_97732_).recipes(this.currentcat).get(this.currentselectedIndex);
    }

    protected void m_280072_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY) {
        ReagenimartRecipe recipe;
        super.m_280072_(graphics, mouseX, mouseY);
        int mouseXinGui = mouseX - this.f_97735_;
        int mouseYinGui = mouseY - this.f_97736_;
        if (mouseXinGui > 4 && mouseXinGui < 23) {
            if (mouseYinGui > 17 && mouseYinGui < 35) {
                graphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.reagenica.building"), mouseX, mouseY);
            } else if (mouseYinGui > 39 && mouseYinGui < 57) {
                graphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.reagenica.commodity"), mouseX, mouseY);
            } else if (mouseYinGui > 61 && mouseYinGui < 79) {
                graphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.reagenica.minerals"), mouseX, mouseY);
            } else if (mouseYinGui > 83 && mouseYinGui < 101) {
                graphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.reagenica.naturals"), mouseX, mouseY);
            }
        } else if (mouseXinGui > 25 && mouseXinGui < 79) {
            int y;
            int x;
            int index;
            if (mouseYinGui > 14 && mouseYinGui < 104 && (index = (x = (mouseXinGui - 25) / 18) + (y = (mouseYinGui - 14) / 18) * 3 + this.currentScroll * 3) < ((ComputerMenu)this.f_97732_).recipes(this.currentcat).size()) {
                ItemStack merchandise = ((ComputerMenu)this.f_97732_).recipes(this.currentcat).get(index).getMerchandise();
                graphics.m_280153_(this.f_96547_, merchandise, mouseX, mouseY);
            }
        } else if (mouseXinGui > 105 && mouseXinGui < 123 && mouseYinGui > 45 && mouseYinGui < 63) {
            ReagenimartRecipe recipe2 = this.getRecipeSelected();
            if (recipe2 != null) {
                ItemStack stack = recipe2.getPrice();
                graphics.m_280153_(this.f_96547_, stack, mouseX, mouseY);
            }
        } else if (mouseXinGui > 144 && mouseXinGui < 162 && mouseYinGui > 45 && mouseYinGui < 63 && (recipe = this.getRecipeSelected()) != null) {
            ItemStack stack = recipe.getMerchandise();
            graphics.m_280153_(this.f_96547_, stack, mouseX, mouseY);
        }
    }

    protected void m_280003_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, 8, 6, 0x404040, false);
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        boolean direction = delta < 0.0;
        int listsize = ((ComputerMenu)this.f_97732_).recipes(this.currentcat).size();
        int scrollable = (listsize - 13) / 3;
        if (scrollable < 0) {
            scrollable = 0;
        }
        this.currentScroll = Mth.m_14045_((int)(this.currentScroll + (direction ? 1 : -1)), (int)0, (int)scrollable);
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        super.m_6375_(mouseX, mouseY, button);
        int mouseXinGui = (int)mouseX - this.f_97735_;
        int mouseYinGui = (int)mouseY - this.f_97736_;
        if (mouseXinGui > 4 && mouseXinGui < 23) {
            if (mouseYinGui > 17 && mouseYinGui < 35) {
                this.currentcat = ReagenimartRecipe.ReagenimartCategory.BUILDING;
                this.currentselectedIndex = -1;
                this.currentScroll = 0;
            } else if (mouseYinGui > 39 && mouseYinGui < 57) {
                this.currentcat = ReagenimartRecipe.ReagenimartCategory.COMMODITY;
                this.currentselectedIndex = -1;
                this.currentScroll = 0;
            } else if (mouseYinGui > 61 && mouseYinGui < 79) {
                this.currentcat = ReagenimartRecipe.ReagenimartCategory.MINERALS;
                this.currentselectedIndex = -1;
                this.currentScroll = 0;
            } else if (mouseYinGui > 83 && mouseYinGui < 101) {
                this.currentcat = ReagenimartRecipe.ReagenimartCategory.NATURALS;
                this.currentselectedIndex = -1;
                this.currentScroll = 0;
            }
            this.sendSelectedRecipe();
        } else if (mouseXinGui > 25 && mouseXinGui < 79 && mouseYinGui > 14 && mouseYinGui < 104) {
            int x = (mouseXinGui - 25) / 18;
            int y = (mouseYinGui - 14) / 18;
            this.currentselectedIndex = x + y * 3 + this.currentScroll * 3;
            this.sendSelectedRecipe();
        }
        return true;
    }

    private void sendSelectedRecipe() {
        if (this.getRecipeSelected() == null) {
            ModMessages.CHANNEL.sendToServer((Object)ComputerOrderPacket.createNullRecipePacket());
        } else {
            ModMessages.CHANNEL.sendToServer((Object)new ComputerOrderPacket(this.currentcat, this.currentselectedIndex));
        }
    }
}

