/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.screen;

import java.util.List;
import kandango.reagenica.ChemiUtils;
import kandango.reagenica.block.entity.electrical.DissolverBlockEntity;
import kandango.reagenica.screen.ChemistryMenu;
import kandango.reagenica.screen.ModMenus;
import kandango.reagenica.screen.slots.SlotPriorityPredicates;
import kandango.reagenica.screen.slots.SlotPriorityRule;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class DissolverMenu
extends ChemistryMenu<DissolverBlockEntity> {
    public DissolverMenu(int id, Inventory inv, FriendlyByteBuf extradata) {
        this(id, inv, (DissolverBlockEntity)inv.f_35978_.m_9236_().m_7702_(extradata.m_130135_()));
    }

    public DissolverMenu(int id, Inventory inv, final DissolverBlockEntity be) {
        super((MenuType)ModMenus.DISSOLVER_MENU.get(), id, inv, be);
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.getProgress();
            }

            public void m_6422_(int value) {
                be.setProgress(value);
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.getEnergy();
            }

            public void m_6422_(int value) {
                be.setEnergy(value);
            }
        });
    }

    @Override
    public List<SlotPriorityRule> quickMoveRules() {
        List<SlotPriorityRule> rules = List.of(SlotPriorityRule.single(SlotPriorityPredicates.IsFluidContainer, 2), SlotPriorityRule.single(SlotPriorityPredicates.IsFluidcase, 4));
        return rules;
    }

    public FluidStack getFluidInput() {
        return ChemiUtils.nonNullOrLog((DissolverBlockEntity)this.blockEntity).map(x -> x.getInputTank().getFluid()).orElse(FluidStack.EMPTY);
    }

    public FluidStack getFluidOutput() {
        return ChemiUtils.nonNullOrLog((DissolverBlockEntity)this.blockEntity).map(x -> x.getOutputTank().getFluid()).orElse(FluidStack.EMPTY);
    }

    public int getTankCapacity() {
        return 8000;
    }

    public int getProgress() {
        return ChemiUtils.nonNullOrLog((DissolverBlockEntity)this.blockEntity).map(x -> x.getProgress()).orElse(0);
    }

    public int getEnergy() {
        return ChemiUtils.nonNullOrLog((DissolverBlockEntity)this.blockEntity).map(x -> x.getEnergy()).orElse(0);
    }

    public int getMaxEnergy() {
        return ChemiUtils.nonNullOrLog((DissolverBlockEntity)this.blockEntity).map(x -> x.getMaxEnergy()).orElse(0);
    }

    @Override
    protected void internalSlots(DissolverBlockEntity be) {
        ItemStackHandler handler = be.getItemHandler();
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 0, 70, 29));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 1, 95, 63));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 2, 23, 30));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 3, 23, 62));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 4, 136, 30));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 5, 136, 62));
    }

    @Override
    protected int slotCount() {
        return 6;
    }
}

