/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.screen;

import java.util.List;
import kandango.reagenica.ChemiUtils;
import kandango.reagenica.block.entity.FractionalDistillerBlockEntity;
import kandango.reagenica.block.entity.util.FluidItemConverter;
import kandango.reagenica.screen.ChemistryMenu;
import kandango.reagenica.screen.ModMenus;
import kandango.reagenica.screen.slots.SlotPriorityPredicates;
import kandango.reagenica.screen.slots.SlotPriorityRule;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class FractionalDistillerMenu
extends ChemistryMenu<FractionalDistillerBlockEntity> {
    public FractionalDistillerMenu(int id, Inventory inv, FriendlyByteBuf extradata) {
        this(id, inv, (FractionalDistillerBlockEntity)inv.f_35978_.m_9236_().m_7702_(extradata.m_130135_()));
    }

    public FractionalDistillerMenu(int id, Inventory inv, final FractionalDistillerBlockEntity be) {
        super((MenuType)ModMenus.FRACTIONAL_DISTILLER_MENU.get(), id, inv, be);
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.getProgress();
            }

            public void m_6422_(int value) {
                be.setProgress(value);
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.getFuel();
            }

            public void m_6422_(int value) {
                be.setFuel(value);
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.getFuelMax();
            }

            public void m_6422_(int value) {
                be.setFuelMax(value);
            }
        });
    }

    @Override
    public List<SlotPriorityRule> quickMoveRules() {
        List<SlotPriorityRule> rules = List.of(SlotPriorityRule.single(SlotPriorityPredicates.IsFuel, 0), SlotPriorityRule.single(SlotPriorityPredicates.IsFluidContainer, 2), SlotPriorityRule.single(SlotPriorityPredicates.IsFluidcase, 6), SlotPriorityRule.single(SlotPriorityPredicates.IsFluidcase, 4), SlotPriorityRule.single(stack -> FluidItemConverter.getFluidstackFromItem(stack).getFluid() == Fluids.f_76193_, 8));
        return rules;
    }

    public FluidStack getFluidInput() {
        return ChemiUtils.nonNullOrLog((FractionalDistillerBlockEntity)this.blockEntity).map(x -> x.getFluidTankInput().getFluid()).orElse(FluidStack.EMPTY);
    }

    public FluidStack getFluidTop() {
        return ChemiUtils.nonNullOrLog((FractionalDistillerBlockEntity)this.blockEntity).map(x -> x.getFluidTankTop().getFluid()).orElse(FluidStack.EMPTY);
    }

    public FluidStack getFluidBottom() {
        return ChemiUtils.nonNullOrLog((FractionalDistillerBlockEntity)this.blockEntity).map(x -> x.getFluidTankBottom().getFluid()).orElse(FluidStack.EMPTY);
    }

    public FluidStack getFluidWater() {
        return ChemiUtils.nonNullOrLog((FractionalDistillerBlockEntity)this.blockEntity).map(x -> x.getFluidTankWater().getFluid()).orElse(FluidStack.EMPTY);
    }

    public int getProgress() {
        return ChemiUtils.nonNullOrLog((FractionalDistillerBlockEntity)this.blockEntity).map(x -> x.getProgress()).orElse(0);
    }

    public int getBurnTime() {
        return ChemiUtils.nonNullOrLog((FractionalDistillerBlockEntity)this.blockEntity).map(x -> x.getFuel()).orElse(0);
    }

    public int getMaxBurnTime() {
        return ChemiUtils.nonNullOrLog((FractionalDistillerBlockEntity)this.blockEntity).map(x -> x.getFuelMax()).orElse(0);
    }

    @Override
    protected void internalSlots(FractionalDistillerBlockEntity be) {
        ItemStackHandler handler = be.getItemHandler();
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 0, 8, 105));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 1, 103, 101));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 2, 8, 13));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 3, 34, 39));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 4, 148, 12));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 5, 148, 37));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 6, 148, 73));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 7, 148, 98));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 8, 62, 13));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 9, 62, 38));
    }

    @Override
    protected int slotCount() {
        return 10;
    }

    @Override
    protected int inv_start() {
        return 124;
    }
}

