/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.screen;

import java.util.List;
import kandango.reagenica.ChemiFluids;
import kandango.reagenica.ChemiUtils;
import kandango.reagenica.block.entity.HaberBoschBlockEntity;
import kandango.reagenica.block.entity.util.FluidItemConverter;
import kandango.reagenica.screen.ChemistryMenu;
import kandango.reagenica.screen.ModMenus;
import kandango.reagenica.screen.slots.SlotPriorityPredicates;
import kandango.reagenica.screen.slots.SlotPriorityRule;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class HaberBoschMenu
extends ChemistryMenu<HaberBoschBlockEntity> {
    public HaberBoschMenu(int id, Inventory inv, FriendlyByteBuf extradata) {
        this(id, inv, (HaberBoschBlockEntity)inv.f_35978_.m_9236_().m_7702_(extradata.m_130135_()));
    }

    public HaberBoschMenu(int id, Inventory inv, final HaberBoschBlockEntity be) {
        super((MenuType)ModMenus.HABER_BOSCH_MENU.get(), id, inv, be);
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.getProgress();
            }

            public void m_6422_(int value) {
                be.setProgress(value);
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.getNitroFluid().getAmount();
            }

            public void m_6422_(int value) {
                be.setNitroAmount(value);
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.getHydroFluid().getAmount();
            }

            public void m_6422_(int value) {
                be.setHydroAmount(value);
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.getOutputFluid().getAmount();
            }

            public void m_6422_(int value) {
                be.setOutputAmount(value);
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.getBurntime();
            }

            public void m_6422_(int value) {
                be.setBurntime(value);
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.getMaxBurnTime();
            }

            public void m_6422_(int value) {
                be.setMaxBurnTime(value);
            }
        });
    }

    @Override
    public List<SlotPriorityRule> quickMoveRules() {
        List<SlotPriorityRule> rules = List.of(SlotPriorityRule.single(SlotPriorityPredicates.IsFluidcase, 5), SlotPriorityRule.single(stack -> FluidItemConverter.getFluidstackFromItem(stack).getFluid().m_6212_(ChemiFluids.HYDROGEN.getFluid()), 1), SlotPriorityRule.single(stack -> FluidItemConverter.getFluidstackFromItem(stack).getFluid().m_6212_(ChemiFluids.OXYGEN.getFluid()), 3));
        return rules;
    }

    public FluidStack getOutputFluid() {
        return ChemiUtils.nonNullOrLog((HaberBoschBlockEntity)this.blockEntity).map(x -> x.getOutputFluid()).orElse(FluidStack.EMPTY);
    }

    public FluidStack getHydroInputFluid() {
        return ChemiUtils.nonNullOrLog((HaberBoschBlockEntity)this.blockEntity).map(x -> x.getHydroFluid()).orElse(FluidStack.EMPTY);
    }

    public FluidStack getNitroInputFluid() {
        return ChemiUtils.nonNullOrLog((HaberBoschBlockEntity)this.blockEntity).map(x -> x.getNitroFluid()).orElse(FluidStack.EMPTY);
    }

    public int getTankCapacity() {
        return 6000;
    }

    public int getProgress() {
        return ChemiUtils.nonNullOrLog((HaberBoschBlockEntity)this.blockEntity).map(x -> x.getProgress()).orElse(0);
    }

    public int getBurnTime() {
        return ChemiUtils.nonNullOrLog((HaberBoschBlockEntity)this.blockEntity).map(x -> x.getBurntime()).orElse(0);
    }

    public int getMaxBurnTime() {
        return ChemiUtils.nonNullOrLog((HaberBoschBlockEntity)this.blockEntity).map(x -> x.getMaxBurnTime()).orElse(0);
    }

    @Override
    protected void internalSlots(HaberBoschBlockEntity be) {
        ItemStackHandler handler = be.getItemHandler();
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 0, 93, 62));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 1, 29, 30));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 2, 29, 62));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 3, 71, 30));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 4, 71, 62));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 5, 136, 30));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 6, 136, 62));
    }

    @Override
    protected int slotCount() {
        return 7;
    }
}

