/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.screen;

import java.util.List;
import kandango.reagenica.ChemiUtils;
import kandango.reagenica.block.entity.electrical.HeatFurnaceBlockEntity;
import kandango.reagenica.screen.ChemistryMenu;
import kandango.reagenica.screen.ModMenus;
import kandango.reagenica.screen.slots.SlotPriorityPredicates;
import kandango.reagenica.screen.slots.SlotPriorityRule;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class HeatFurnaceMenu
extends ChemistryMenu<HeatFurnaceBlockEntity> {
    public HeatFurnaceMenu(int id, Inventory inv, FriendlyByteBuf extradata) {
        this(id, inv, (HeatFurnaceBlockEntity)inv.f_35978_.m_9236_().m_7702_(extradata.m_130135_()));
    }

    public HeatFurnaceMenu(int id, Inventory inv, final HeatFurnaceBlockEntity be) {
        super((MenuType)ModMenus.HEAT_FURNACE_MENU.get(), id, inv, be);
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.getFuel();
            }

            public void m_6422_(int value) {
                be.setFuel(value);
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.getFuelMax();
            }

            public void m_6422_(int value) {
                be.setFuelMax(value);
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.getProgress();
            }

            public void m_6422_(int value) {
                be.setProgress(value);
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.isUsingEnergy() ? 1 : 0;
            }

            public void m_6422_(int value) {
                be.setUsingEnergy(value != 0);
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.getEnergy();
            }

            public void m_6422_(int value) {
                be.setEnergy(value);
            }
        });
    }

    @Override
    public List<SlotPriorityRule> quickMoveRules() {
        List<SlotPriorityRule> rules = List.of(SlotPriorityRule.single(SlotPriorityPredicates.IsFuel, 1), SlotPriorityRule.single(SlotPriorityPredicates.IsFluidcase, 6), SlotPriorityRule.single(SlotPriorityPredicates.IsFluidContainer, 4));
        return rules;
    }

    public FluidStack getFluidInput() {
        return ChemiUtils.nonNullOrLog((HeatFurnaceBlockEntity)this.blockEntity).map(x -> x.getInputTank().getFluid()).orElse(FluidStack.EMPTY);
    }

    public FluidStack getFluidOutput() {
        return ChemiUtils.nonNullOrLog((HeatFurnaceBlockEntity)this.blockEntity).map(x -> x.getOutputTank().getFluid()).orElse(FluidStack.EMPTY);
    }

    public int getTankCapacity() {
        return 8000;
    }

    public int getBurnTime() {
        return ChemiUtils.nonNullOrLog((HeatFurnaceBlockEntity)this.blockEntity).map(x -> x.getFuel()).orElse(0);
    }

    public int getMaxBurnTime() {
        return ChemiUtils.nonNullOrLog((HeatFurnaceBlockEntity)this.blockEntity).map(x -> x.getFuelMax()).orElse(0);
    }

    public int getProgress() {
        return ChemiUtils.nonNullOrLog((HeatFurnaceBlockEntity)this.blockEntity).map(x -> x.getProgress()).orElse(0);
    }

    public int getEnergy() {
        return ChemiUtils.nonNullOrLog((HeatFurnaceBlockEntity)this.blockEntity).map(x -> x.getEnergy()).orElse(0);
    }

    public int getMaxEnergy() {
        return ChemiUtils.nonNullOrLog((HeatFurnaceBlockEntity)this.blockEntity).map(x -> x.getMaxEnergy()).orElse(0);
    }

    public boolean isUsingEnergy() {
        return ChemiUtils.nonNullOrLog((HeatFurnaceBlockEntity)this.blockEntity).map(x -> x.isUsingEnergy()).orElse(false);
    }

    @Override
    protected void internalSlots(HeatFurnaceBlockEntity be) {
        ItemStackHandler handler = be.getItemHandler();
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 0, 56, 23));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 1, 56, 59));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 2, 109, 24));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 3, 109, 48));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 4, 5, 30));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 5, 5, 62));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 6, 155, 30));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 7, 155, 62));
    }

    @Override
    protected int slotCount() {
        return 8;
    }
}

