/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.screen;

import java.util.Optional;
import javax.annotation.Nonnull;
import kandango.reagenica.block.fluid.hotspring.OnsenTypes;
import kandango.reagenica.screen.ModMenus;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Climate;

public class OnsenDetecterMenu
extends AbstractContainerMenu {
    private static final float ENCODE_SCALE = 1000.0f;
    private final Level level;
    private final BlockPos pos;
    private final ContainerData datas;

    public OnsenDetecterMenu(int id, Level level, BlockPos pos) {
        super((MenuType)ModMenus.ONSEN_DETECTER_MENU.get(), id);
        this.level = level;
        this.pos = pos;
        this.datas = new SimpleContainerData(6);
        this.m_38884_(this.datas);
        if (level instanceof ServerLevel) {
            ServerLevel slv = (ServerLevel)level;
            Climate.TargetPoint tp = OnsenTypes.getGeology(slv, this.pos);
            this.datas.m_8050_(0, this.encode(tp.f_187005_()));
            this.datas.m_8050_(1, this.encode(tp.f_187003_()));
            this.datas.m_8050_(2, this.encode(tp.f_187004_()));
            this.datas.m_8050_(3, this.encode(tp.f_187006_()));
            this.datas.m_8050_(4, this.encode(tp.f_187008_()));
            this.datas.m_8050_(5, OnsenTypes.getOnsenTypeFrom(tp).getOrdinal());
        }
    }

    private int encode(long raw) {
        return (int)(Climate.m_186796_((long)raw) * 1000.0f);
    }

    public float getContinentalness() {
        return (float)this.datas.m_6413_(0) / 1000.0f;
    }

    public float getTemperature() {
        return (float)this.datas.m_6413_(1) / 1000.0f;
    }

    public float getHumidity() {
        return (float)this.datas.m_6413_(2) / 1000.0f;
    }

    public float getErosion() {
        return (float)this.datas.m_6413_(3) / 1000.0f;
    }

    public float getWeirdness() {
        return (float)this.datas.m_6413_(4) / 1000.0f;
    }

    public OnsenTypes getOnsenType() {
        return OnsenTypes.getOnsenTypeOf(this.datas.m_6413_(5));
    }

    public Optional<Level> getLevel() {
        return Optional.ofNullable(this.level);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public ItemStack m_7648_(@Nonnull Player player, int slot) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(@Nonnull Player player) {
        return true;
    }
}

