/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import kandango.reagenica.screen.OnsenDetecterMenu;
import kandango.reagenica.screen.components.IScreenComponent;
import kandango.reagenica.screen.components.VirtualTankComponent;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class OnsenDetecterScreen
extends AbstractContainerScreen<OnsenDetecterMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("reagenica", "textures/gui/onsen_analyzer.png");
    private final List<IScreenComponent> components = new ArrayList<IScreenComponent>();
    private final FluidTank virtualTank = new FluidTank(200);

    public OnsenDetecterScreen(OnsenDetecterMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.f_97727_ = 165;
        this.f_97731_ = 9999;
        this.components.add(new VirtualTankComponent(this.virtualTank, 24, 26, menu.getPos()));
    }

    protected void m_7286_(@Nonnull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.virtualTank.setFluid(new FluidStack(((OnsenDetecterMenu)this.f_97732_).getOnsenType().getFluid(), 120));
        for (IScreenComponent component : this.components) {
            component.render(graphics, partialTicks, mouseX, mouseY, this.f_97736_, this.f_97735_);
        }
        graphics.m_280430_(this.f_96547_, ((OnsenDetecterMenu)this.f_97732_).getOnsenType().getNameComponent(), this.f_97735_ + 53, this.f_97736_ + 26, 0xFEFEFE);
        this.drawLongString(graphics, this.f_96547_, ((OnsenDetecterMenu)this.f_97732_).getOnsenType().getLoreComponent(), this.f_97735_ + 53, this.f_97736_ + 40, 0xD0D0D0);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.reagenica.continentalness"), this.f_97735_ + 25, this.f_97736_ + 95, 0x404040, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.reagenica.erosion"), this.f_97735_ + 25, this.f_97736_ + 107, 0x404040, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.reagenica.weirdness"), this.f_97735_ + 25, this.f_97736_ + 119, 0x404040, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.reagenica.humidity"), this.f_97735_ + 25, this.f_97736_ + 131, 0x404040, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.reagenica.temperature"), this.f_97735_ + 25, this.f_97736_ + 143, 0x404040, false);
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)this.simple(((OnsenDetecterMenu)this.f_97732_).getContinentalness())), this.f_97735_ + 100, this.f_97736_ + 95, 0xFEFEFE);
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)this.simple(((OnsenDetecterMenu)this.f_97732_).getErosion())), this.f_97735_ + 100, this.f_97736_ + 107, 0xFEFEFE);
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)this.simple(((OnsenDetecterMenu)this.f_97732_).getWeirdness())), this.f_97735_ + 100, this.f_97736_ + 119, 0xFEFEFE);
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)this.simple(((OnsenDetecterMenu)this.f_97732_).getHumidity())), this.f_97735_ + 100, this.f_97736_ + 131, 0xFEFEFE);
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)this.simple(((OnsenDetecterMenu)this.f_97732_).getTemperature())), this.f_97735_ + 100, this.f_97736_ + 143, 0xFEFEFE);
    }

    private String simple(float value) {
        return String.format(Locale.US, "%.4f", Float.valueOf(value));
    }

    private void drawLongString(GuiGraphics graphics, Font font, Component longText, int x, int y, int color) {
        int maxWidth = 100;
        List lines = font.m_92923_((FormattedText)longText, 100);
        int yOffset = 0;
        for (FormattedCharSequence line : lines) {
            graphics.m_280648_(font, line, x, y + yOffset, color);
            Objects.requireNonNull(font);
            yOffset += 9;
        }
    }

    protected void m_280072_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280072_(graphics, mouseX, mouseY);
        for (IScreenComponent component : this.components) {
            component.tooltip(graphics, mouseX, mouseY, this.f_97736_, this.f_97735_, this.f_96547_);
        }
    }

    protected void m_280003_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, 8, 6, 0x404040, false);
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.m_280072_(graphics, mouseX, mouseY);
    }
}

