/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.screen;

import java.util.List;
import kandango.reagenica.ChemiUtils;
import kandango.reagenica.block.entity.ReactorBlockEntity;
import kandango.reagenica.screen.ChemistryMenu;
import kandango.reagenica.screen.ModMenus;
import kandango.reagenica.screen.slots.SlotPriorityPredicates;
import kandango.reagenica.screen.slots.SlotPriorityRule;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ReactorMenu
extends ChemistryMenu<ReactorBlockEntity> {
    public ReactorMenu(int id, Inventory inv, FriendlyByteBuf extradata) {
        this(id, inv, (ReactorBlockEntity)inv.f_35978_.m_9236_().m_7702_(extradata.m_130135_()));
    }

    public ReactorMenu(int id, Inventory inv, final ReactorBlockEntity be) {
        super((MenuType)ModMenus.REACTOR_MENU.get(), id, inv, be);
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return be.isSCRAMed() ? 1 : 0;
            }

            public void m_6422_(int value) {
                be.setSCRAMed(value != 0);
            }
        });
    }

    @Override
    public List<SlotPriorityRule> quickMoveRules() {
        List<SlotPriorityRule> rules = List.of(SlotPriorityRule.single(SlotPriorityPredicates.IsFluidContainer, 9));
        return rules;
    }

    public FluidStack getFluidMain() {
        return ChemiUtils.nonNullOrLog((ReactorBlockEntity)this.blockEntity).map(x -> x.getFluidTankMain().getFluid()).orElse(FluidStack.EMPTY);
    }

    public FluidStack getFluidHeat() {
        return ChemiUtils.nonNullOrLog((ReactorBlockEntity)this.blockEntity).map(x -> x.getFluidTankHeat().getFluid()).orElse(FluidStack.EMPTY);
    }

    public int getTankCapacity() {
        return 4000;
    }

    public boolean isSCRAMed() {
        return ChemiUtils.nonNullOrLog((ReactorBlockEntity)this.blockEntity).map(x -> x.isSCRAMed()).orElse(true);
    }

    @Override
    protected void internalSlots(ReactorBlockEntity be) {
        ItemStackHandler handler = be.getItemHandler();
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 0, 62, 55));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 1, 80, 55));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 2, 98, 55));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 3, 62, 73));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 4, 80, 73));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 5, 98, 73));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 6, 62, 91));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 7, 80, 91));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 8, 98, 91));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 9, 22, 34));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 10, 22, 66));
    }

    @Override
    protected int slotCount() {
        return 11;
    }

    @Override
    protected int inv_start() {
        return 124;
    }
}

