/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import kandango.reagenica.client.ClientRenderUtil;
import kandango.reagenica.screen.SolarPowerGeneratorMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;

public class SolarPowerGeneratorScreen
extends AbstractContainerScreen<SolarPowerGeneratorMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("reagenica", "textures/gui/container/solar_generator.png");

    public SolarPowerGeneratorScreen(SolarPowerGeneratorMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.f_97727_ = 165;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    protected void m_7286_(@Nonnull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int energy = ((SolarPowerGeneratorMenu)this.f_97732_).getEnergy();
        int capacity = ((SolarPowerGeneratorMenu)this.f_97732_).getMaxEnergy();
        ClientRenderUtil.renderEnergyInGui(TEXTURE, graphics, this.f_97735_, this.f_97736_, energy, capacity, 133, 37, 176, 33, 3, 16);
        Level lv = ((SolarPowerGeneratorMenu)this.f_97732_).getLevel();
        if (lv != null) {
            boolean isClear = !lv.m_46471_() && !lv.m_46470_();
            int dayTime = (int)(lv.m_46468_() % 24000L);
            boolean isBlocked = ((SolarPowerGeneratorMenu)this.f_97732_).isBlocked();
            if (dayTime < 12000) {
                if (isClear) {
                    graphics.m_280218_(TEXTURE, this.f_97735_ + 52, this.f_97736_ + 39, 176, 50, 7, 7);
                } else {
                    graphics.m_280218_(TEXTURE, this.f_97735_ + 52, this.f_97736_ + 39, 197, 50, 7, 7);
                }
            } else if (13000 < dayTime && dayTime < 23000) {
                graphics.m_280218_(TEXTURE, this.f_97735_ + 52, this.f_97736_ + 39, 190, 50, 7, 7);
            } else if (isClear) {
                graphics.m_280218_(TEXTURE, this.f_97735_ + 52, this.f_97736_ + 39, 183, 50, 7, 7);
            } else {
                graphics.m_280218_(TEXTURE, this.f_97735_ + 52, this.f_97736_ + 39, 197, 50, 7, 7);
            }
            if (isBlocked) {
                graphics.m_280218_(TEXTURE, this.f_97735_ + 38, this.f_97736_ + 37, 196, 57, 11, 11);
            }
        }
    }

    protected void m_280072_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280072_(graphics, mouseX, mouseY);
        int tankX = this.f_97735_ + 132;
        int tankY = this.f_97736_ + 36;
        int tankWidth = 5;
        int tankHeight = 18;
        if (this.isMouseOver(mouseX, mouseY, tankX, tankY, tankWidth, tankHeight)) {
            int energy = ((SolarPowerGeneratorMenu)this.f_97732_).getEnergy();
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237113_((String)"Energy"));
            tooltip.add(Component.m_237113_((String)(energy + " EU")));
            graphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
        }
        if (((SolarPowerGeneratorMenu)this.f_97732_).isBlocked() && this.isMouseOver(mouseX, mouseY, this.f_97735_ + 38, this.f_97736_ + 37, 11, 11)) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237115_((String)"gui.reagenica.solar_panel_blocked"));
            graphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    private boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    protected void m_280003_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, 8, 6, 0x404040, false);
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.m_280072_(graphics, mouseX, mouseY);
    }
}

