/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.screen.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import kandango.reagenica.client.ClientRenderUtil;
import kandango.reagenica.screen.components.IScreenComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TankComponent
implements IScreenComponent {
    private final FluidTank tank;
    private final BlockPos pos;
    private final int x;
    private final int y;
    private final int width;
    private final int height;

    public TankComponent(FluidTank tank, int x, int y, BlockPos pos) {
        this(tank, x, y, 16, 48, pos);
    }

    public TankComponent(FluidTank tank, int x, int y, int width, int height, BlockPos pos) {
        this.tank = tank;
        this.pos = pos;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public void render(@Nonnull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY, int topPos, int leftPos) {
        ClientRenderUtil.renderFluidInGui(graphics, this.tank.getFluid(), (BlockAndTintGetter)Minecraft.m_91087_().f_91073_, this.pos, leftPos + this.x, topPos + this.y, this.width, this.height, this.tank.getCapacity());
    }

    @Override
    public void tooltip(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, int topPos, int leftPos, Font font) {
        if (this.isMouseOver(leftPos + this.x, topPos + this.y, this.width, this.height, mouseX, mouseY)) {
            FluidStack fluid = this.tank.getFluid();
            if (!fluid.isEmpty()) {
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                tooltip.add(Component.m_237115_((String)fluid.getTranslationKey()));
                tooltip.add(Component.m_237113_((String)(fluid.getAmount() + " mB")));
                graphics.m_280677_(font, tooltip, Optional.empty(), mouseX, mouseY);
            } else {
                graphics.m_280677_(font, List.of(Component.m_237113_((String)"Empty")), Optional.empty(), mouseX, mouseY);
            }
        }
    }
}

