/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.villager.goals;

import java.util.Optional;
import kandango.reagenica.ChemistryMod;
import kandango.reagenica.block.entity.TradingStallBlockEntity;
import kandango.reagenica.villager.StallVisitCooldown;
import kandango.reagenica.villager.pois.ChemiPOIs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class VisitStallGoal
extends Goal {
    private final Villager villager;
    private final double speed;
    private BlockPos targetpos;

    public VisitStallGoal(Villager villager, double speed) {
        this.villager = villager;
        this.speed = speed;
    }

    public boolean m_8036_() {
        ServerLevel level;
        PoiManager poiManager;
        Optional maybePos;
        long nextVisit;
        long gameTime = this.villager.m_9236_().m_46467_();
        if (gameTime < (nextVisit = StallVisitCooldown.getStallVisitCooldown(this.villager).getNextVisitTime())) {
            return false;
        }
        if (!this.isMorningOrEvening()) {
            return false;
        }
        if (!this.isMorningOrEvening()) {
            return false;
        }
        if (this.villager.m_6274_().m_21874_(MemoryModuleType.f_26370_)) {
            return false;
        }
        if (!this.villager.m_6274_().m_21954_(Activity.f_37979_)) {
            return false;
        }
        Level level2 = this.villager.m_9236_();
        if (level2 instanceof ServerLevel && (maybePos = (poiManager = (level = (ServerLevel)level2).m_8904_()).m_217951_(holder -> holder.m_203565_(ChemiPOIs.STALL_POI.getKey()), pos -> true, PoiManager.Occupancy.ANY, this.villager.m_20183_(), 32, this.villager.m_217043_())).isPresent()) {
            this.targetpos = (BlockPos)maybePos.orElseThrow(() -> new IllegalStateException("It's a magic!"));
            return true;
        }
        return false;
    }

    public void m_8056_() {
        this.villager.m_21573_().m_26519_((double)this.targetpos.m_123341_() + 0.5, (double)this.targetpos.m_123342_() + 0.5, (double)this.targetpos.m_123343_() + 0.5, this.speed);
    }

    public boolean m_8045_() {
        return this.targetpos != null && !this.villager.m_21573_().m_26571_();
    }

    public void m_8041_() {
        if (this.isReachedTarget()) {
            this.villager.m_6674_(InteractionHand.MAIN_HAND);
            Level level = this.villager.m_9236_();
            long gameTime = level.m_46467_();
            BlockEntity be = level.m_7702_(this.targetpos);
            if (be instanceof TradingStallBlockEntity) {
                TradingStallBlockEntity stall = (TradingStallBlockEntity)be;
                long nexttime = stall.trade(this.villager, level);
                StallVisitCooldown.getStallVisitCooldown(this.villager).setNextVisitTime(gameTime + nexttime);
            } else {
                ChemistryMod.LOGGER.error("There was no trading stall at pos {}.", (Object)this.targetpos);
            }
        }
    }

    public boolean m_6767_() {
        return false;
    }

    private boolean isMorningOrEvening() {
        long dayTime = this.villager.m_9236_().m_8044_() % 24000L;
        return dayTime > 0L && dayTime < 2000L || dayTime > 10000L && dayTime < 12000L;
    }

    private boolean isReachedTarget() {
        return this.villager.m_20238_(Vec3.m_82512_((Vec3i)this.targetpos)) < 9.0;
    }
}

