/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.worldgen.cave;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Optional;
import javax.annotation.Nonnull;
import kandango.reagenica.worldgen.cave.CaveCrystalPatchConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class CaveCrystalPatchFeature
extends Feature<CaveCrystalPatchConfig> {
    public CaveCrystalPatchFeature(Codec<CaveCrystalPatchConfig> config) {
        super(config);
    }

    public boolean m_142674_(@Nonnull FeaturePlaceContext<CaveCrystalPatchConfig> ctx) {
        WorldGenLevel lv = ctx.m_159774_();
        BlockPos origin = ctx.m_159777_();
        RandomSource random = ctx.m_225041_();
        CaveCrystalPatchConfig config = (CaveCrystalPatchConfig)ctx.m_159778_();
        HashSet<BlockPos> crystalSpawns = new HashSet<BlockPos>();
        for (int i = 0; i < config.count().m_214085_(random); ++i) {
            int dx = random.m_188503_(21) - 10;
            int dz = random.m_188503_(21) - 10;
            crystalSpawns.add(origin.m_7918_(dx, 0, dz));
        }
        for (BlockPos startpos : crystalSpawns) {
            this.getCrystalPos(lv, startpos).ifPresent(pos -> this.setCrystal(lv, (BlockPos)pos, config.crystal().m_213972_(random, pos)));
        }
        return true;
    }

    private void setCrystal(WorldGenLevel lv, BlockPos pos, BlockState crystal) {
        if (lv.m_8055_(pos).m_60819_().m_192917_((Fluid)Fluids.f_76193_) && crystal.m_61138_((Property)BlockStateProperties.f_61362_)) {
            BlockState waterCrystal = (BlockState)crystal.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
            this.m_5974_((LevelWriter)lv, pos, waterCrystal);
        } else {
            this.m_5974_((LevelWriter)lv, pos, crystal);
        }
    }

    private Optional<BlockPos> getCrystalPos(WorldGenLevel lv, BlockPos origin) {
        if (lv.m_8055_(origin).m_60795_()) {
            BlockPos.MutableBlockPos pos = origin.m_122032_();
            for (int i = 0; i < 10; ++i) {
                pos.m_122184_(0, -1, 0);
                BlockState state = lv.m_8055_((BlockPos)pos);
                if (this.isAirOrWater(state)) continue;
                if (state.m_60819_().m_192917_((Fluid)Fluids.f_76195_)) {
                    return Optional.empty();
                }
                return Optional.of(pos.m_122184_(0, 1, 0).m_7949_());
            }
        } else {
            BlockPos.MutableBlockPos pos = origin.m_122032_();
            for (int i = 0; i < 10; ++i) {
                pos.m_122184_(0, 1, 0);
                BlockState state = lv.m_8055_((BlockPos)pos);
                if (state.m_60819_().m_192917_((Fluid)Fluids.f_76195_)) {
                    return Optional.empty();
                }
                if (!this.isAirOrWater(state)) continue;
                return Optional.of(pos.m_7949_());
            }
        }
        return Optional.empty();
    }

    private boolean isAirOrWater(BlockState state) {
        return state.m_60795_() || state.m_60819_().m_192917_((Fluid)Fluids.f_76193_);
    }
}

