/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.worldgen.cave;

import com.mojang.serialization.Codec;
import java.util.Optional;
import javax.annotation.Nonnull;
import kandango.reagenica.ChemiTags;
import kandango.reagenica.worldgen.cave.CaveStreamConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class CaveStreamFeature
extends Feature<CaveStreamConfig> {
    public CaveStreamFeature(Codec<CaveStreamConfig> config) {
        super(config);
    }

    public boolean m_142674_(@Nonnull FeaturePlaceContext<CaveStreamConfig> ctx) {
        WorldGenLevel lv = ctx.m_159774_();
        BlockPos origin = ctx.m_159777_();
        RandomSource random = ctx.m_225041_();
        CaveStreamConfig config = (CaveStreamConfig)ctx.m_159778_();
        BlockPos.MutableBlockPos pos = origin.m_122032_();
        float rockiness = config.rockiness().m_214084_(random);
        for (int x = -10; x <= 10; ++x) {
            for (int z = -10; z <= 10; ++z) {
                if (x * x + z * z > 100) continue;
                pos.m_122178_(origin.m_123341_(), origin.m_123342_(), origin.m_123343_());
                pos.m_122184_(x, 0, z);
                this.getFloorPos(lv, (BlockPos)pos).filter(p -> this.isPlaceable(lv, (BlockPos)p)).ifPresent(floor -> {
                    BlockState state = lv.m_8055_(floor);
                    if (state.m_204336_(ChemiTags.Blocks.CAVE_REPLACEABLE)) {
                        if (random.m_188501_() < rockiness) {
                            if (random.m_188501_() < 0.4f * (1.1f - rockiness)) {
                                this.m_5974_((LevelWriter)lv, (BlockPos)floor, config.ore().m_213972_(random, floor));
                            } else {
                                this.m_5974_((LevelWriter)lv, (BlockPos)floor, config.block().m_213972_(random, floor));
                            }
                        } else if (this.isWaterPlaceable(lv, (BlockPos)floor)) {
                            this.m_5974_((LevelWriter)lv, (BlockPos)floor, Blocks.f_49990_.m_49966_());
                        } else {
                            this.m_5974_((LevelWriter)lv, (BlockPos)floor, config.block().m_213972_(random, floor));
                        }
                    }
                });
                this.getCeilingPos(lv, (BlockPos)pos).filter(p -> this.isPlaceable(lv, (BlockPos)p)).ifPresent(ceil -> {
                    BlockState state = lv.m_8055_(ceil);
                    if (state.m_204336_(ChemiTags.Blocks.CAVE_REPLACEABLE)) {
                        if (random.m_188501_() < 0.1f) {
                            this.m_5974_((LevelWriter)lv, (BlockPos)ceil, config.ore().m_213972_(random, ceil));
                        } else {
                            this.m_5974_((LevelWriter)lv, (BlockPos)ceil, config.block().m_213972_(random, ceil));
                        }
                    }
                });
            }
        }
        return true;
    }

    private boolean isPlaceable(WorldGenLevel lv, BlockPos pos) {
        BlockState state = lv.m_8055_(pos);
        BlockState below = lv.m_8055_(pos.m_7495_());
        FluidState fstate = state.m_60819_();
        FluidState fbelow = below.m_60819_();
        if (!fstate.m_76178_() && !fstate.m_192917_((Fluid)Fluids.f_76193_)) {
            return false;
        }
        return !fstate.m_192917_((Fluid)Fluids.f_76193_) || !fbelow.m_192917_((Fluid)Fluids.f_76193_);
    }

    private boolean isWaterPlaceable(WorldGenLevel lv, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        BlockState bottom = lv.m_8055_(below);
        if (bottom.m_60722_((Fluid)Fluids.f_76193_)) {
            return false;
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos rel = pos.m_121945_(dir);
            BlockState neighbor = lv.m_8055_(rel);
            if (neighbor.m_60819_().m_192917_((Fluid)Fluids.f_76193_) || !neighbor.m_60722_((Fluid)Fluids.f_76193_)) continue;
            return false;
        }
        return true;
    }

    private Optional<BlockPos> getFloorPos(WorldGenLevel lv, BlockPos origin) {
        if (lv.m_8055_(origin).m_60795_()) {
            BlockPos.MutableBlockPos pos = origin.m_122032_();
            for (int i = 0; i < 10; ++i) {
                pos.m_122184_(0, -1, 0);
                if (lv.m_8055_((BlockPos)pos).m_60795_()) continue;
                return Optional.of(pos.m_7949_());
            }
        } else {
            BlockPos.MutableBlockPos pos = origin.m_122032_();
            for (int i = 0; i < 10; ++i) {
                pos.m_122184_(0, 1, 0);
                if (!lv.m_8055_((BlockPos)pos).m_60795_()) continue;
                return Optional.of(pos.m_122184_(0, -1, 0).m_7949_());
            }
        }
        return Optional.empty();
    }

    private Optional<BlockPos> getCeilingPos(WorldGenLevel lv, BlockPos origin) {
        if (lv.m_8055_(origin).m_60795_()) {
            BlockPos.MutableBlockPos pos = origin.m_122032_();
            for (int i = 0; i < 10; ++i) {
                pos.m_122184_(0, 1, 0);
                if (lv.m_8055_((BlockPos)pos).m_60795_()) continue;
                return Optional.of(pos.m_7949_());
            }
        } else {
            BlockPos.MutableBlockPos pos = origin.m_122032_();
            for (int i = 0; i < 10; ++i) {
                pos.m_122184_(0, -1, 0);
                if (!lv.m_8055_((BlockPos)pos).m_60795_()) continue;
                return Optional.of(pos.m_122184_(0, 1, 0).m_7949_());
            }
        }
        return Optional.empty();
    }
}

