/*
 * Decompiled with CFR 0.152.
 */
package kandango.reagenica.worldgen.mushroom;

import com.mojang.serialization.Codec;
import java.util.Optional;
import javax.annotation.Nonnull;
import kandango.reagenica.worldgen.mushroom.LargeMushroomConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class LargeMushroomFeature
extends Feature<LargeMushroomConfig> {
    public LargeMushroomFeature(Codec<LargeMushroomConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(@Nonnull FeaturePlaceContext<LargeMushroomConfig> ctx) {
        WorldGenLevel lv = ctx.m_159774_();
        BlockPos origin = ctx.m_159777_();
        RandomSource random = ctx.m_225041_();
        LargeMushroomConfig config = (LargeMushroomConfig)ctx.m_159778_();
        int height = config.height().m_214085_(random);
        for (int y = 0; y < height; ++y) {
            BlockPos pos = origin.m_6630_(y);
            this.m_5974_((LevelWriter)lv, pos, config.stem().m_213972_(random, pos));
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                this.m_5974_((LevelWriter)lv, pos.m_121945_(dir), config.stem().m_213972_(random, pos));
            }
        }
        int capHeight = height / 2 + 2;
        for (int y = 0; y < capHeight; ++y) {
            boolean isLowest = y == capHeight - 1;
            int offset = height - y + 1;
            int radius = isLowest ? y : y + 1;
            BlockPos center = origin.m_6630_(offset);
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos pos = center.m_7918_(dx, 0, dz);
                    this.getStateForPlace(dx, dz, radius, pos, random, config, isLowest).ifPresent(state -> this.m_5974_((LevelWriter)lv, pos, (BlockState)state));
                }
            }
        }
        return true;
    }

    private Optional<BlockState> getStateForPlace(int dx, int dz, int radius, BlockPos pos, RandomSource random, LargeMushroomConfig cfg, boolean isFinalLevel) {
        int sqDistance = dx * dx + dz * dz;
        int sqRad = radius * radius;
        int sqUpRad = (radius - 1) * (radius - 1);
        if (sqDistance <= sqUpRad) {
            if (!isFinalLevel) {
                return Optional.of(cfg.inside().m_213972_(random, pos));
            }
            return Optional.empty();
        }
        if (sqDistance <= sqRad) {
            return Optional.of(cfg.surface().m_213972_(random, pos));
        }
        return Optional.empty();
    }
}

