/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.dungeonblocks;

import com.everydayxp.dungeonblocks.block.WaveSpawnerBlockEntity;
import com.everydayxp.dungeonblocks.config.DungeonBlocksConfig;
import com.everydayxp.dungeonblocks.network.ModNetwork;
import com.everydayxp.dungeonblocks.registry.ModBlockEntities;
import com.everydayxp.dungeonblocks.registry.ModBlocks;
import com.everydayxp.dungeonblocks.registry.ModItems;
import com.everydayxp.dungeonblocks.util.DungeonBlocksJsonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="dungeonblocks")
public class DungeonBlocks {
    public static final String MODID = "dungeonblocks";
    public static final Logger LOGGER = LogManager.getLogger();

    public DungeonBlocks() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBlocks.BLOCKS.register(modBus);
        ModBlockEntities.BLOCK_ENTITIES.register(modBus);
        ModItems.ITEMS.register(modBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DungeonBlocksConfig.COMMON_SPEC, "dungeonblocks/dungeonblocks-common.toml");
        modBus.addListener(this::onCommonSetup);
        ModNetwork.register();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("[DungeonBlocks] onCommonSetup llamado");
        event.enqueueWork(() -> {
            LOGGER.info("[DungeonBlocks] Ejecutando DungeonBlocksJsonConfig.init()");
            DungeonBlocksJsonConfig.init();
        });
    }

    @SubscribeEvent
    public void onMobDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        CompoundTag data = entity.getPersistentData();
        if (!data.m_128441_("DungeonBlocksSpawnerPos")) {
            return;
        }
        long packedPos = data.m_128454_("DungeonBlocksSpawnerPos");
        BlockPos pos = BlockPos.m_122022_((long)packedPos);
        Level level = entity.m_9236_();
        if (level.f_46443_) {
            return;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof WaveSpawnerBlockEntity) {
            WaveSpawnerBlockEntity spawner = (WaveSpawnerBlockEntity)be;
            spawner.onMobDied(entity);
        }
    }

    @SubscribeEvent
    public void onMobXpDrop(LivingExperienceDropEvent event) {
        LivingEntity entity = event.getEntity();
        CompoundTag data = entity.getPersistentData();
        if (data.m_128471_("DungeonBlocksNoXp")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onMobDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        CompoundTag data = entity.getPersistentData();
        if (data.m_128471_("DungeonBlocksNoXp")) {
            event.getDrops().clear();
        }
    }
}

