/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.dungeonblocks.block;

import com.everydayxp.dungeonblocks.config.DungeonBlocksConfig;
import com.everydayxp.dungeonblocks.network.BossInfoS2CPacket;
import com.everydayxp.dungeonblocks.network.ModNetwork;
import com.everydayxp.dungeonblocks.registry.ModBlockEntities;
import com.everydayxp.dungeonblocks.util.DungeonBlocksJsonConfig;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BossSpawnerBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random RNG = new Random();
    private static final double MAX_DISTANCE = 10.0;
    private static final double MAX_DISTANCE_SQ = 100.0;
    private static final int PLAYER_CHECK_INTERVAL = 20;
    private static final int BOSSBAR_UPDATE_INTERVAL = 20;
    private static final int BOSS_TIME_LIMIT_TICKS = 3600;
    private int bossTimerTicks = 0;
    private AABB cachedPlayerCheckBox = null;
    private AABB cachedCleanupBox = null;
    private static final List<String> BASE_NAMES = List.of("Jack", "Rainbow", "Lex", "Draven", "Zorak");
    private static final List<String> SUFFIXES = List.of("of the Storm", "of the Tempest", "the Wise", "the Destroyer", "the Eternal");
    private String selectedBossId = null;
    private boolean active = false;
    private boolean finished = false;
    private boolean useBossBar = true;
    private ServerBossEvent bossBar;
    private UUID bossUuid;
    private int tickCounter = 0;
    private int playerCheckCooldown = 0;
    private boolean activationInProgress = false;

    public BossSpawnerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.BOSS_SPAWNER.get(), pos, state);
    }

    private void debugLog(String message, Object ... args) {
        if (((Boolean)DungeonBlocksConfig.COMMON.debugLoggingEnabled.get()).booleanValue()) {
            LOGGER.info("[BossSpawner {}] {}", (Object)this.f_58858_, (Object)String.format(message, args));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivated(Player player) {
        if (this.activationInProgress || this.active || this.finished) {
            return;
        }
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (!this.f_58857_.m_46805_(this.f_58858_)) {
            return;
        }
        this.activationInProgress = true;
        try {
            DungeonBlocksJsonConfig.BossEntity bossConfig;
            this.debugLog("Activado por {}", player.m_7755_().getString());
            if (DungeonBlocksJsonConfig.BOSS_CONFIG.isEmpty()) {
                this.debugLog("No bosses configurados en bosses.json", new Object[0]);
                return;
            }
            if (this.selectedBossId == null) {
                this.selectedBossId = this.selectValidBossId();
                if (this.selectedBossId == null) {
                    this.debugLog("No se encontr\u00c3\u00b3 ning\u00c3\u00ban boss v\u00c3\u00a1lido en bosses.json", new Object[0]);
                    return;
                }
                this.m_6596_();
            }
            if ((bossConfig = (DungeonBlocksJsonConfig.BossEntity)DungeonBlocksJsonConfig.BOSS_CONFIG.stream().filter(cfg -> cfg.id.equals(this.selectedBossId)).findFirst().orElse(null)) == null) {
                this.debugLog("Config perdida para boss fijo: {}", this.selectedBossId);
                return;
            }
            LivingEntity boss = this.spawnBossEntity(server, bossConfig);
            if (boss == null) {
                this.debugLog("Fall\u00c3\u00b3 el spawn del boss", new Object[0]);
                return;
            }
            this.configureBoss(boss, bossConfig);
            this.bossUuid = boss.m_20148_();
            this.useBossBar = bossConfig.bossbar;
            this.active = true;
            this.finished = false;
            this.tickCounter = 0;
            this.playerCheckCooldown = 0;
            this.bossTimerTicks = 3600;
            this.syncBossTimer();
            if (this.useBossBar && this.bossBar != null) {
                this.updateBossBarPlayers(server, boss);
            }
            this.m_6596_();
            this.debugLog("Boss spawnado: {} (200\u00e2\u2122\u00a5, bossbar={})", bossConfig.id, this.useBossBar);
        }
        finally {
            this.activationInProgress = false;
        }
    }

    private String selectValidBossId() {
        List<DungeonBlocksJsonConfig.BossEntity> validBosses = DungeonBlocksJsonConfig.BOSS_CONFIG.stream().filter(cfg -> ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(cfg.id)) != null).toList();
        if (validBosses.isEmpty()) {
            return null;
        }
        return validBosses.get((int)BossSpawnerBlockEntity.RNG.nextInt((int)validBosses.size())).id;
    }

    private LivingEntity spawnBossEntity(ServerLevel server, DungeonBlocksJsonConfig.BossEntity bossConfig) {
        ResourceLocation bossId = new ResourceLocation(bossConfig.id);
        EntityType bossType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(bossId);
        if (bossType == null) {
            this.debugLog("Tipo de entidad no encontrado: {}", bossId);
            return null;
        }
        BlockPos spawnPos = this.findValidSpawnPosition(server);
        if (spawnPos == null) {
            this.debugLog("No se encontr\u00c3\u00b3 posici\u00c3\u00b3n de spawn v\u00c3\u00a1lida", new Object[0]);
            return null;
        }
        LivingEntity boss = (LivingEntity)bossType.m_20615_((Level)server);
        if (boss != null) {
            boss.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_() + 0.1, (double)spawnPos.m_123343_() + 0.5, 0.0f, 0.0f);
            server.m_47205_((Entity)boss);
            if (boss instanceof Mob) {
                Mob mob = (Mob)boss;
                mob.m_6518_((ServerLevelAccessor)server, server.m_6436_(spawnPos), MobSpawnType.SPAWNER, null, null);
            }
        }
        return boss;
    }

    private BlockPos findValidSpawnPosition(ServerLevel server) {
        BlockPos basePos = this.f_58858_.m_7494_();
        if (this.isValidSpawnPosition(server, basePos)) {
            return basePos;
        }
        for (int radius = 1; radius <= 3; ++radius) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos candidate;
                    if (Math.abs(x) != radius && Math.abs(z) != radius || !this.isValidSpawnPosition(server, candidate = this.f_58858_.m_7918_(x, 1, z))) continue;
                    return candidate;
                }
            }
        }
        return null;
    }

    private boolean isValidSpawnPosition(ServerLevel server, BlockPos pos) {
        if (!server.m_8055_(pos.m_7495_()).m_280296_()) {
            return false;
        }
        return server.m_8055_(pos).m_60795_() && server.m_8055_(pos.m_7494_()).m_60795_();
    }

    private void configureBoss(LivingEntity boss, DungeonBlocksJsonConfig.BossEntity bossConfig) {
        Component name = this.randomBossName();
        boss.m_6593_(name);
        boss.m_20340_(true);
        boss.m_146915_(true);
        boss.getPersistentData().m_128356_("DungeonBossSpawnerPos", this.f_58858_.m_121878_());
        this.configureVanillaEquipment(boss);
        this.setBossHealth(boss, 200.0);
        this.applyBossEffects(boss);
        if (this.useBossBar) {
            this.bossBar = new ServerBossEvent(name, BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);
            this.bossBar.m_142711_(1.0f);
            this.bossBar.m_8321_(true);
        }
    }

    private void configureVanillaEquipment(LivingEntity boss) {
        ResourceLocation typeId = ForgeRegistries.ENTITY_TYPES.getKey((Object)boss.m_6095_());
        if (typeId == null || !"minecraft".equals(typeId.m_135827_())) {
            return;
        }
        if (boss.m_21205_().m_41619_()) {
            ItemStack weapon;
            String path;
            switch (path = typeId.m_135815_()) {
                case "pillager": {
                    ItemStack itemStack = new ItemStack((ItemLike)Items.f_42717_);
                    break;
                }
                case "skeleton": 
                case "stray": {
                    ItemStack itemStack = new ItemStack((ItemLike)Items.f_42411_);
                    break;
                }
                case "vindicator": {
                    ItemStack itemStack = new ItemStack((ItemLike)Items.f_42386_);
                    break;
                }
                case "zombie": {
                    ItemStack itemStack = new ItemStack((ItemLike)Items.f_42383_);
                    break;
                }
                default: {
                    ItemStack itemStack = weapon = null;
                }
            }
            if (weapon != null) {
                boss.m_8061_(EquipmentSlot.MAINHAND, weapon);
            }
        }
    }

    private void setBossHealth(LivingEntity boss, double targetHealth) {
        AttributeInstance healthAttr = boss.m_21051_(Attributes.f_22276_);
        if (healthAttr != null) {
            healthAttr.m_22100_(targetHealth);
            boss.m_21153_((float)targetHealth);
        }
    }

    private Component randomBossName() {
        return Component.m_237113_((String)(BASE_NAMES.get(RNG.nextInt(BASE_NAMES.size())) + " " + SUFFIXES.get(RNG.nextInt(SUFFIXES.size()))));
    }

    public static void serverTick(Level lvl, BlockPos pos, BlockState state, BossSpawnerBlockEntity be) {
        if (be.finished || !be.active) {
            return;
        }
        if (!(lvl instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)lvl;
        if (!server.m_46805_(pos)) {
            return;
        }
        ++be.tickCounter;
        LivingEntity boss = be.getCachedBoss(server);
        if (boss == null || !boss.m_6084_()) {
            be.debugLog("Boss perdido o muerto \u00e2\u2020\u2019 finalizar", new Object[0]);
            be.finishArenaWithChest(server);
            return;
        }
        if (be.bossTimerTicks > 0) {
            --be.bossTimerTicks;
            if (be.bossTimerTicks % 5 == 0) {
                be.syncBossTimer();
            }
            if (be.bossTimerTicks <= 0) {
                be.debugLog("Tiempo agotado \u00e2\u2020\u2019 boss desaparece y evento se resetea", new Object[0]);
                boss.m_146870_();
                be.resetArena();
                return;
            }
        }
        ++be.playerCheckCooldown;
        if (be.playerCheckCooldown >= 20) {
            be.playerCheckCooldown = 0;
            if (!be.checkPlayersNearby(server)) {
                be.resetArena();
                return;
            }
        }
        if (be.tickCounter % 20 == 0 && be.useBossBar && be.bossBar != null) {
            be.updateBossBar(boss, server);
        }
    }

    private void syncBossTimer() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        ModNetwork.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> server.m_46745_(this.f_58858_)), (Object)new BossInfoS2CPacket(this.f_58858_, this.active && !this.finished, this.bossTimerTicks));
    }

    private LivingEntity getCachedBoss(ServerLevel server) {
        if (this.bossUuid == null) {
            return null;
        }
        return (LivingEntity)server.m_8791_(this.bossUuid);
    }

    private boolean checkPlayersNearby(ServerLevel server) {
        List players;
        if (this.cachedPlayerCheckBox == null) {
            this.cachedPlayerCheckBox = new AABB(this.f_58858_).m_82400_(10.0);
        }
        if ((players = server.m_45976_(ServerPlayer.class, this.cachedPlayerCheckBox)).isEmpty()) {
            return false;
        }
        double centerX = (double)this.f_58858_.m_123341_() + 0.5;
        double centerZ = (double)this.f_58858_.m_123343_() + 0.5;
        for (ServerPlayer player : players) {
            double dz;
            double dx;
            if (!player.m_6084_() || player.m_5833_() || !((dx = player.m_20185_() - centerX) * dx + (dz = player.m_20189_() - centerZ) * dz <= 100.0)) continue;
            return true;
        }
        return false;
    }

    private void updateBossBar(LivingEntity boss, ServerLevel server) {
        if (this.bossBar == null || !this.useBossBar) {
            return;
        }
        float healthRatio = Math.max(0.0f, boss.m_21223_() / boss.m_21233_());
        this.bossBar.m_142711_(healthRatio);
        this.updateBossBarPlayers(server, boss);
    }

    private void updateBossBarPlayers(ServerLevel server, LivingEntity boss) {
        if (this.bossBar == null) {
            return;
        }
        if (this.cachedPlayerCheckBox == null) {
            this.cachedPlayerCheckBox = new AABB(this.f_58858_).m_82400_(10.0);
        }
        this.bossBar.m_7706_();
        double centerX = (double)this.f_58858_.m_123341_() + 0.5;
        double centerZ = (double)this.f_58858_.m_123343_() + 0.5;
        for (ServerPlayer player : server.m_45976_(ServerPlayer.class, this.cachedPlayerCheckBox)) {
            double dz;
            double dx;
            if (!player.m_6084_() || player.m_5833_() || !((dx = player.m_20185_() - centerX) * dx + (dz = player.m_20189_() - centerZ) * dz <= 100.0)) continue;
            this.bossBar.m_6543_(player);
        }
    }

    private void resetArena() {
        this.debugLog("Reset - sin jugadores", new Object[0]);
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (this.cachedCleanupBox == null) {
                this.cachedCleanupBox = new AABB(this.f_58858_).m_82400_(12.0);
            }
            server.m_6443_(LivingEntity.class, this.cachedCleanupBox, e -> e.getPersistentData().m_128454_("DungeonBossSpawnerPos") == this.f_58858_.m_121878_()).forEach(Entity::m_146870_);
        }
        this.cleanup();
        this.syncBossTimer();
    }

    private void cleanup() {
        this.active = false;
        this.bossUuid = null;
        this.cleanupBossBar();
        this.tickCounter = 0;
        this.playerCheckCooldown = 0;
        this.bossTimerTicks = 0;
        this.m_6596_();
    }

    private void cleanupBossBar() {
        if (this.bossBar != null) {
            this.bossBar.m_7706_();
            this.bossBar.m_8321_(false);
            this.bossBar = null;
        }
    }

    private void finishArenaWithChest(ServerLevel server) {
        this.debugLog("Boss derrotado \u00e2\u2020\u2019 cofre", new Object[0]);
        server.m_46597_(this.f_58858_, Blocks.f_50087_.m_49966_());
        BlockEntity be = server.m_7702_(this.f_58858_);
        if (be instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)be;
            chest.m_59626_(new ResourceLocation("minecraft:chests/simple_dungeon"), server.f_46441_.m_188505_());
        }
        this.active = false;
        this.finished = true;
        this.cleanupBossBar();
        this.bossTimerTicks = 0;
        this.m_6596_();
        this.syncBossTimer();
    }

    private void applyBossEffects(LivingEntity boss) {
        if (!((Boolean)DungeonBlocksConfig.COMMON.bossPotionEffectsEnabled.get()).booleanValue()) {
            return;
        }
        if (boss.m_9236_() == null) {
            return;
        }
        for (String effectStr : (List)DungeonBlocksConfig.COMMON.bossPotionEffects.get()) {
            String[] parts = effectStr.split(":");
            if (parts.length != 4) continue;
            try {
                ResourceLocation id = new ResourceLocation(parts[0], parts[1]);
                MobEffect effect = (MobEffect)boss.m_9236_().m_9598_().m_175515_(Registries.f_256929_).m_7745_(id);
                if (effect == null) continue;
                boss.m_7292_(new MobEffectInstance(effect, Integer.parseInt(parts[3]), Integer.parseInt(parts[2]), false, true));
            }
            catch (Exception e) {
                this.debugLog("Error aplicando efecto: {}", e.getMessage());
            }
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("Active", this.active);
        tag.m_128379_("Finished", this.finished);
        tag.m_128379_("UseBossBar", this.useBossBar);
        tag.m_128405_("TickCounter", this.tickCounter);
        tag.m_128405_("PlayerCheckCooldown", this.playerCheckCooldown);
        tag.m_128405_("BossTimerTicks", this.bossTimerTicks);
        if (this.bossUuid != null) {
            tag.m_128362_("BossUUID", this.bossUuid);
        }
        if (this.selectedBossId != null) {
            tag.m_128359_("SelectedBossId", this.selectedBossId);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.active = tag.m_128471_("Active");
        this.finished = tag.m_128471_("Finished");
        this.useBossBar = tag.m_128471_("UseBossBar");
        this.tickCounter = tag.m_128451_("TickCounter");
        this.playerCheckCooldown = tag.m_128451_("PlayerCheckCooldown");
        this.bossTimerTicks = tag.m_128451_("BossTimerTicks");
        if (tag.m_128403_("BossUUID")) {
            this.bossUuid = tag.m_128342_("BossUUID");
        }
        if (tag.m_128441_("SelectedBossId")) {
            this.selectedBossId = tag.m_128461_("SelectedBossId");
        }
        this.cachedPlayerCheckBox = null;
        this.cachedCleanupBox = null;
    }

    public void forceReset() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (this.cachedCleanupBox == null) {
                this.cachedCleanupBox = new AABB(this.f_58858_).m_82400_(12.0);
            }
            server.m_6443_(LivingEntity.class, this.cachedCleanupBox, e -> e.getPersistentData().m_128454_("DungeonBossSpawnerPos") == this.f_58858_.m_121878_()).forEach(Entity::m_146870_);
        }
        this.active = false;
        this.finished = false;
        this.bossUuid = null;
        this.cleanupBossBar();
        this.tickCounter = 0;
        this.playerCheckCooldown = 0;
        this.bossTimerTicks = 0;
        this.m_6596_();
        this.syncBossTimer();
    }
}

