/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.dungeonblocks.block;

import com.everydayxp.dungeonblocks.config.DungeonBlocksConfig;
import com.everydayxp.dungeonblocks.network.ModNetwork;
import com.everydayxp.dungeonblocks.network.WaveInfoS2CPacket;
import com.everydayxp.dungeonblocks.registry.ModBlockEntities;
import com.everydayxp.dungeonblocks.util.DungeonBlocksJsonConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WaveSpawnerBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random RNG = new Random();
    private static final double MAX_DISTANCE = 6.0;
    private static final double MAX_DISTANCE_SQR = 36.0;
    private static final double CANCEL_RADIUS = 10.0;
    private static final double CANCEL_RADIUS_SQR = 100.0;
    private static final int[] WAVE_SIZES = new int[]{4, 6, 8, 10, 12};
    private static final int MAX_WAVE_SIZE = 12;
    private static final int MAX_SPAWN_ATTEMPTS = 10;
    private static final int PLAYER_CHECK_INTERVAL = 20;
    private static final int CLEANUP_INTERVAL = 100;
    private String cachedBiomeId = null;
    private int cachedBiomeGroup = -2;
    private List<EntityType<?>> cachedMobPool = null;
    private AABB cachedCancelBox = null;
    private boolean active = false;
    private boolean finished = false;
    private int currentWave = 0;
    private int mobsAlive = 0;
    private int playerCheckCooldown = 0;
    private boolean waveInProgress = false;
    private int tickCounter = 0;
    private int lastCleanupTick = 0;
    private EntityType<?> selectedMobType = null;
    private ResourceLocation selectedMobId = null;
    private final List<UUID> spawnedMobs = new ArrayList<UUID>(12);

    public WaveSpawnerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.WAVE_SPAWNER.get(), pos, state);
    }

    private void debugLog(String message, Object ... args) {
        if (((Boolean)DungeonBlocksConfig.COMMON.debugLoggingEnabled.get()).booleanValue()) {
            LOGGER.info("[WaveSpawner {}] {}", (Object)this.f_58858_, (Object)String.format(message, args));
        }
    }

    public void onActivated(Player player) {
        if (this.finished || this.active || this.waveInProgress) {
            return;
        }
        if (!(this.f_58857_ instanceof ServerLevel)) {
            return;
        }
        if (!this.f_58857_.m_46805_(this.f_58858_)) {
            return;
        }
        this.debugLog("Activado por {}", player.m_7755_().getString());
        this.active = true;
        this.finished = false;
        this.currentWave = 0;
        this.mobsAlive = 0;
        this.waveInProgress = false;
        this.spawnedMobs.clear();
        this.tickCounter = 0;
        this.lastCleanupTick = 0;
        this.invalidateCache();
        if (!this.selectEventMob()) {
            this.debugLog("No se pudo seleccionar mob para el evento", new Object[0]);
            this.resetArena();
            return;
        }
        this.startWave(0);
        this.syncWaveInfo();
    }

    private boolean selectEventMob() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel server = (ServerLevel)level;
        List<EntityType<?>> mobPool = this.getCachedMobPool(server);
        if (mobPool.isEmpty()) {
            this.debugLog("No hay mobs disponibles para este bioma", new Object[0]);
            return false;
        }
        this.selectedMobType = mobPool.get(RNG.nextInt(mobPool.size()));
        this.selectedMobId = ForgeRegistries.ENTITY_TYPES.getKey(this.selectedMobType);
        this.debugLog("Entidad seleccionada para TODO el evento: {}", this.selectedMobId);
        this.m_6596_();
        return true;
    }

    private List<EntityType<?>> getCachedMobPool(ServerLevel server) {
        List<EntityType<?>> mobs;
        if (this.selectedMobType != null) {
            this.debugLog("Usando entidad pre-seleccionada: {}", this.selectedMobId);
            return Collections.singletonList(this.selectedMobType);
        }
        if (this.cachedMobPool != null && this.cachedBiomeGroup != -2) {
            return this.cachedMobPool;
        }
        if (this.cachedBiomeId == null) {
            this.cachedBiomeId = this.getBiomeId(server);
            this.debugLog("Biome detectado: '{}'", this.cachedBiomeId);
        }
        if (this.cachedBiomeGroup == -2) {
            Integer groupObj = DungeonBlocksJsonConfig.WAVE_BIOME_GROUPS.get(this.cachedBiomeId);
            this.cachedBiomeGroup = groupObj != null ? groupObj : -1;
            this.debugLog("Biome '{}' \u00e2\u2020\u2019 grupo: {}", this.cachedBiomeId, this.cachedBiomeGroup);
        }
        if ((mobs = this.getMobsInGroup(this.cachedBiomeGroup)).isEmpty()) {
            this.debugLog("Grupo {} vac\u00c3\u00ado, usando zombies fallback", this.cachedBiomeGroup);
            mobs = this.getFallbackZombies();
        }
        mobs.removeIf(Objects::isNull);
        this.cachedMobPool = mobs;
        if (!this.cachedMobPool.isEmpty()) {
            StringBuilder mobList = new StringBuilder("Mobs disponibles: ");
            for (EntityType<?> mob : this.cachedMobPool) {
                ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey(mob);
                mobList.append(id != null ? id.toString() : "null").append(", ");
            }
            this.debugLog(mobList.toString(), new Object[0]);
        }
        return this.cachedMobPool;
    }

    private int spawnWaveMobs(ServerLevel server, int count, List<EntityType<?>> mobPool) {
        if (this.selectedMobType == null) {
            this.debugLog("ERROR: No hay entidad seleccionada para spawnear", new Object[0]);
            return 0;
        }
        this.debugLog("Spawneando {} mobs de tipo: {}", count, this.selectedMobId);
        int spawned = 0;
        for (int i = 0; i < count; ++i) {
            this.debugLog("Intento {}/{}: Spawneando {}", i + 1, count, this.selectedMobId);
            LivingEntity mob = this.attemptSpawnMob(server, this.selectedMobType);
            if (mob != null) {
                mob.getPersistentData().m_128356_("DungeonBlocksSpawnerPos", this.f_58858_.m_121878_());
                this.spawnedMobs.add(mob.m_20148_());
                this.debugLog("\u00c2\u00a1Spawn exitoso! Total: {}/{}", ++spawned, count);
                if (this.spawnedMobs.size() <= 24) continue;
                this.spawnedMobs.subList(0, this.spawnedMobs.size() - 12).clear();
                continue;
            }
            this.debugLog("Fall\u00c3\u00b3 el spawn de {}", this.selectedMobId);
        }
        this.debugLog("Wave completada: {}/{} mobs spawnados", spawned, count);
        return spawned;
    }

    private LivingEntity attemptSpawnMob(ServerLevel server, EntityType<?> mobType) {
        if (mobType == null) {
            this.debugLog("Mob type es null", new Object[0]);
            return null;
        }
        BlockPos spawnPos = this.findValidSpawnPosition();
        if (spawnPos == null) {
            this.debugLog("No se encontr\u00c3\u00b3 posici\u00c3\u00b3n v\u00c3\u00a1lida para {}", ForgeRegistries.ENTITY_TYPES.getKey(mobType));
            return null;
        }
        this.debugLog("Spawneando {} en {}", ForgeRegistries.ENTITY_TYPES.getKey(mobType), spawnPos);
        EntityType<?> livingType = mobType;
        try {
            LivingEntity entity = (LivingEntity)livingType.m_262455_(server, (CompoundTag)null, null, spawnPos, MobSpawnType.SPAWNER, true, false);
            if (entity == null) {
                this.debugLog("spawn() devolvi\u00c3\u00b3 null", new Object[0]);
                return null;
            }
            entity.m_6021_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_() + 1.0, (double)spawnPos.m_123343_() + 0.5);
            this.equipVanillaMob(entity);
            entity.m_146915_(true);
            this.applyConfiguredEffects(entity);
            this.debugLog("\u00c2\u00a1{} creado exitosamente!", entity.m_7755_().getString());
            return entity;
        }
        catch (Exception e) {
            this.debugLog("Error spawnando: {}", e.getMessage());
            return null;
        }
    }

    private BlockPos findValidSpawnPosition() {
        if (this.f_58857_ == null) {
            return null;
        }
        for (int radius = 1; radius <= 6; ++radius) {
            for (int attempt = 0; attempt < 3; ++attempt) {
                int dx = RNG.nextInt(radius * 2 + 1) - radius;
                int dz = RNG.nextInt(radius * 2 + 1) - radius;
                if (dx == 0 && dz == 0 || (double)(dx * dx + dz * dz) > 36.0) continue;
                for (int yOffset = -2; yOffset <= 2; ++yOffset) {
                    BlockPos candidate = this.f_58858_.m_7918_(dx, yOffset, dz);
                    if (!this.isValidSpawnPosition(candidate)) continue;
                    this.debugLog("Posici\u00c3\u00b3n encontrada: {} (radio {}, altura {})", candidate, radius, yOffset);
                    return candidate;
                }
            }
        }
        this.debugLog("No se encontr\u00c3\u00b3 posici\u00c3\u00b3n v\u00c3\u00a1lida despu\u00c3\u00a9s de b\u00c3\u00basqueda exhaustiva", new Object[0]);
        return null;
    }

    private boolean isValidSpawnPosition(BlockPos pos) {
        boolean aboveHasSolidCollision;
        boolean hereHasSolidCollision;
        if (this.f_58857_ == null) {
            return false;
        }
        BlockState belowState = this.f_58857_.m_8055_(pos.m_7495_());
        BlockState hereState = this.f_58857_.m_8055_(pos);
        BlockState aboveState = this.f_58857_.m_8055_(pos.m_7494_());
        if (!belowState.m_280296_()) {
            return false;
        }
        if (!hereState.m_60819_().m_76178_()) {
            return false;
        }
        boolean bl = hereHasSolidCollision = !hereState.m_60812_((BlockGetter)this.f_58857_, pos).m_83281_();
        if (hereHasSolidCollision) {
            return false;
        }
        if (!aboveState.m_60819_().m_76178_()) {
            return false;
        }
        boolean bl2 = aboveHasSolidCollision = !aboveState.m_60812_((BlockGetter)this.f_58857_, pos.m_7494_()).m_83281_();
        return !aboveHasSolidCollision;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, WaveSpawnerBlockEntity be) {
        if (!be.active || be.finished) {
            return;
        }
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (!server.m_46805_(pos)) {
            return;
        }
        ++be.tickCounter;
        ++be.playerCheckCooldown;
        if (be.tickCounter - be.lastCleanupTick > 100) {
            be.cleanupDeadMobs(server);
            be.lastCleanupTick = be.tickCounter;
        }
        if (be.playerCheckCooldown >= 20) {
            be.playerCheckCooldown = 0;
            if (!be.checkPlayersInArena(server)) {
                be.resetArena();
                return;
            }
        }
        if (be.waveInProgress && be.mobsAlive <= 0) {
            be.waveInProgress = false;
            be.startNextWave();
        }
    }

    private boolean checkPlayersInArena(ServerLevel server) {
        if (this.cachedCancelBox == null) {
            this.cachedCancelBox = new AABB((double)this.f_58858_.m_123341_() - 10.0, (double)(this.f_58858_.m_123342_() - 2), (double)this.f_58858_.m_123343_() - 10.0, (double)this.f_58858_.m_123341_() + 10.0 + 1.0, (double)(this.f_58858_.m_123342_() + 4), (double)this.f_58858_.m_123343_() + 10.0 + 1.0);
        }
        double centerX = (double)this.f_58858_.m_123341_() + 0.5;
        double centerY = (double)this.f_58858_.m_123342_() + 0.5;
        double centerZ = (double)this.f_58858_.m_123343_() + 0.5;
        for (Player player : server.m_45976_(Player.class, this.cachedCancelBox)) {
            double dz;
            double dy;
            double dx;
            if (!player.m_6084_() || player.m_5833_() || !((dx = player.m_20185_() - centerX) * dx + (dy = player.m_20186_() - centerY) * dy + (dz = player.m_20189_() - centerZ) * dz <= 100.0)) continue;
            return true;
        }
        return false;
    }

    public void onMobDied(LivingEntity entity) {
        if (!this.active || this.finished) {
            return;
        }
        --this.mobsAlive;
        this.debugLog("Mob muri\u00c3\u00b3, restantes: {} wave: {}", this.mobsAlive, this.currentWave + 1);
        if (this.mobsAlive <= 0) {
            this.waveInProgress = false;
            this.startNextWave();
        } else {
            this.syncWaveInfo();
        }
    }

    private void startNextWave() {
        int nextWave = this.currentWave + 1;
        if (nextWave >= WAVE_SIZES.length) {
            this.debugLog("Todas las waves completadas!", new Object[0]);
            this.finishArena();
            return;
        }
        this.startWave(nextWave);
    }

    private void startWave(int waveIndex) {
        if (waveIndex >= WAVE_SIZES.length) {
            this.finishArena();
            return;
        }
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        this.waveInProgress = true;
        this.currentWave = waveIndex;
        int waveSize = WAVE_SIZES[waveIndex];
        this.debugLog("Iniciando wave {} con {} mobs de tipo: {}", this.currentWave + 1, waveSize, this.selectedMobId);
        if (this.selectedMobType == null) {
            this.debugLog("ERROR: No hay entidad seleccionada para la wave", new Object[0]);
            this.resetArena();
            return;
        }
        int spawnedCount = this.spawnWaveMobs(server, waveSize, Collections.singletonList(this.selectedMobType));
        if (spawnedCount == 0) {
            this.debugLog("Wave {} fall\u00c3\u00b3 (0 mobs spawnados)", this.currentWave + 1);
            this.resetArena();
            return;
        }
        this.mobsAlive = spawnedCount;
        this.debugLog("Wave {} lista con {} mobs", this.currentWave + 1, this.mobsAlive);
        this.syncWaveInfo();
    }

    private void resetArena() {
        this.debugLog("Reset arena", new Object[0]);
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            for (UUID mobId : this.spawnedMobs) {
                LivingEntity mob = (LivingEntity)server.m_8791_(mobId);
                if (mob == null || !mob.m_6084_()) continue;
                mob.m_146870_();
            }
        }
        this.spawnedMobs.clear();
        this.active = false;
        this.finished = false;
        this.currentWave = 0;
        this.mobsAlive = 0;
        this.waveInProgress = false;
        this.tickCounter = 0;
        this.lastCleanupTick = 0;
        this.invalidateCache();
        this.syncWaveInfo();
    }

    private void finishArena() {
        this.active = false;
        this.finished = true;
        this.waveInProgress = false;
        this.debugLog("Arena completada \u00e2\u2020\u2019 Cofre", new Object[0]);
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_46597_(this.f_58858_, Blocks.f_50087_.m_49966_());
            BlockEntity be = server.m_7702_(this.f_58858_);
            if (be instanceof ChestBlockEntity) {
                ChestBlockEntity chest = (ChestBlockEntity)be;
                chest.m_59626_(new ResourceLocation("minecraft", "chests/simple_dungeon"), server.f_46441_.m_188505_());
            }
        }
        this.syncWaveInfo();
    }

    private String getBiomeId(ServerLevel server) {
        try {
            Holder biomeHolder = server.m_204166_(this.f_58858_);
            return biomeHolder.m_203543_().map(key -> key.m_135782_().toString()).orElse("minecraft:unknown");
        }
        catch (Exception e) {
            this.debugLog("Error obteniendo biome: {}", e.getMessage());
            return "minecraft:unknown";
        }
    }

    private List<EntityType<?>> getMobsInGroup(int groupId) {
        if (groupId == -1) {
            return Collections.emptyList();
        }
        ArrayList mobs = new ArrayList();
        for (DungeonBlocksJsonConfig.GroupedEntity ge : DungeonBlocksJsonConfig.WAVE_GROUPED_ENTITIES) {
            EntityType type;
            if (ge.group != groupId || (type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(ge.id))) == null) continue;
            mobs.add(type);
        }
        return mobs;
    }

    private List<EntityType<?>> getFallbackZombies() {
        EntityType zombie = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("minecraft:zombie"));
        return zombie != null ? Collections.singletonList(zombie) : Collections.emptyList();
    }

    private void equipVanillaMob(LivingEntity entity) {
        ResourceLocation typeId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (typeId == null || !"minecraft".equals(typeId.m_135827_())) {
            return;
        }
        if (entity.m_21205_().m_41619_()) {
            ItemStack weapon;
            String path;
            switch (path = typeId.m_135815_()) {
                case "pillager": {
                    ItemStack itemStack = new ItemStack((ItemLike)Items.f_42717_);
                    break;
                }
                case "skeleton": 
                case "stray": {
                    ItemStack itemStack = new ItemStack((ItemLike)Items.f_42411_);
                    break;
                }
                case "vindicator": {
                    ItemStack itemStack = new ItemStack((ItemLike)Items.f_42386_);
                    break;
                }
                case "zombie": {
                    ItemStack itemStack = new ItemStack((ItemLike)Items.f_42383_);
                    break;
                }
                default: {
                    ItemStack itemStack = weapon = null;
                }
            }
            if (weapon != null) {
                entity.m_8061_(EquipmentSlot.MAINHAND, weapon);
            }
        }
    }

    private void cleanupDeadMobs(ServerLevel server) {
        Iterator<UUID> iterator = this.spawnedMobs.iterator();
        while (iterator.hasNext()) {
            UUID mobId = iterator.next();
            LivingEntity mob = (LivingEntity)server.m_8791_(mobId);
            if (mob != null && mob.m_6084_()) continue;
            iterator.remove();
        }
    }

    private void syncWaveInfo() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int displayedWave = Math.max(0, this.currentWave);
        ModNetwork.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> server.m_46745_(this.f_58858_)), (Object)new WaveInfoS2CPacket(this.f_58858_, this.active && !this.finished, displayedWave, WAVE_SIZES.length, this.mobsAlive));
    }

    private void invalidateCache() {
        this.cachedBiomeId = null;
        this.cachedBiomeGroup = -2;
        this.cachedMobPool = null;
        this.cachedCancelBox = null;
    }

    private void applyConfiguredEffects(LivingEntity entity) {
        if (!((Boolean)DungeonBlocksConfig.COMMON.wavePotionEffectsEnabled.get()).booleanValue()) {
            return;
        }
        if (entity.m_9236_() == null) {
            return;
        }
        for (String effectStr : (List)DungeonBlocksConfig.COMMON.wavePotionEffects.get()) {
            String[] parts = effectStr.split(":");
            if (parts.length != 4) continue;
            try {
                ResourceLocation effectId = new ResourceLocation(parts[0], parts[1]);
                MobEffect effect = (MobEffect)entity.m_9236_().m_9598_().m_175515_(Registries.f_256929_).m_7745_(effectId);
                if (effect == null) continue;
                int amplifier = Integer.parseInt(parts[2]);
                int duration = Integer.parseInt(parts[3]);
                entity.m_7292_(new MobEffectInstance(effect, duration, amplifier));
            }
            catch (Exception e) {
                this.debugLog("Error aplicando efecto: {}", e.getMessage());
            }
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("Active", this.active);
        tag.m_128379_("Finished", this.finished);
        tag.m_128379_("WaveInProgress", this.waveInProgress);
        tag.m_128405_("CurrentWave", this.currentWave);
        tag.m_128405_("MobsAlive", this.mobsAlive);
        tag.m_128405_("TickCounter", this.tickCounter);
        tag.m_128405_("LastCleanupTick", this.lastCleanupTick);
        tag.m_128405_("PlayerCheckCooldown", this.playerCheckCooldown);
        if (this.selectedMobId != null) {
            tag.m_128359_("SelectedMobId", this.selectedMobId.toString());
        }
        if (!this.spawnedMobs.isEmpty()) {
            long[] mobIds = new long[this.spawnedMobs.size() * 2];
            int idx = 0;
            for (UUID uuid : this.spawnedMobs) {
                mobIds[idx++] = uuid.getMostSignificantBits();
                mobIds[idx++] = uuid.getLeastSignificantBits();
            }
            tag.m_128388_("SpawnedMobs", mobIds);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.active = tag.m_128471_("Active");
        this.finished = tag.m_128471_("Finished");
        this.waveInProgress = tag.m_128471_("WaveInProgress");
        this.currentWave = tag.m_128451_("CurrentWave");
        this.mobsAlive = tag.m_128451_("MobsAlive");
        this.tickCounter = tag.m_128451_("TickCounter");
        this.lastCleanupTick = tag.m_128451_("LastCleanupTick");
        this.playerCheckCooldown = tag.m_128451_("PlayerCheckCooldown");
        if (tag.m_128441_("SelectedMobId")) {
            String mobIdStr = tag.m_128461_("SelectedMobId");
            this.selectedMobId = new ResourceLocation(mobIdStr);
            this.selectedMobType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(this.selectedMobId);
            if (this.selectedMobType != null) {
                this.debugLog("Cargada entidad seleccionada: {}", this.selectedMobId);
            } else {
                this.debugLog("ERROR: No se pudo cargar entidad: {}", mobIdStr);
                this.selectedMobId = null;
            }
        }
        this.spawnedMobs.clear();
        if (tag.m_128441_("SpawnedMobs")) {
            long[] mobIds = tag.m_128467_("SpawnedMobs");
            for (int i = 0; i < mobIds.length; i += 2) {
                this.spawnedMobs.add(new UUID(mobIds[i], mobIds[i + 1]));
            }
        }
        this.invalidateCache();
    }

    public int getCurrentWave() {
        return this.currentWave;
    }

    public int getTotalWaves() {
        return WAVE_SIZES.length;
    }

    public int getMobsAlive() {
        return this.mobsAlive;
    }

    public ResourceLocation getSelectedMobId() {
        return this.selectedMobId;
    }

    public boolean isActive() {
        return this.active && !this.finished;
    }
}

