/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.dungeonblocks.client;

import com.everydayxp.dungeonblocks.client.ClientBossData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeonblocks", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientBossHud {
    public static final IGuiOverlay BOSS_HUD = (gui, graphics, partialTick, screenWidth, screenHeight) -> {
        if (!ClientBossData.isActiveAndNearby()) {
            return;
        }
        int ticks = ClientBossData.getTimeTicks();
        if (ticks <= 0) {
            return;
        }
        float ticksInterpolated = (float)ticks - partialTick;
        float totalSeconds = ticksInterpolated / 20.0f;
        int minutes = (int)(totalSeconds / 60.0f);
        int seconds = (int)(totalSeconds % 60.0f);
        float fractional = totalSeconds - (float)((int)totalSeconds);
        int centis = (int)(fractional * 100.0f);
        if (centis < 0) {
            centis = 0;
        }
        String timeStr = String.format("%02d:%02d:%02d", minutes, seconds, centis);
        String line = "Boss Timer: " + timeStr;
        int x = screenWidth / 2 - gui.m_93082_().m_92895_(line) / 2;
        int y = 30;
        graphics.m_280056_(gui.m_93082_(), line, x, y, 0xFF5555, true);
    };

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("dungeonblocks_boss_hud", BOSS_HUD);
    }
}

