/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.dungeonblocks.config;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DungeonBlocksConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON = (Common)pair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)pair.getRight();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue wavePotionEffectsEnabled;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> wavePotionEffects;
        public final ForgeConfigSpec.BooleanValue bossPotionEffectsEnabled;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bossPotionEffects;
        public final ForgeConfigSpec.BooleanValue debugLoggingEnabled;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("waves");
            this.wavePotionEffectsEnabled = builder.comment("If true, mobs from wave spawners can receive potion effects from config.").define("wavePotionEffectsEnabled", true);
            this.wavePotionEffects = builder.comment("List of mob effects for wave mobs, format: 'namespace:effect:amplifier:durationTicks'.").defineList("wavePotionEffects", List.of("minecraft:speed:0:400", "minecraft:strength:0:400"), o -> o instanceof String);
            builder.pop();
            builder.push("bosses");
            this.bossPotionEffectsEnabled = builder.comment("If true, boss spawners can receive potion effects from config.").define("bossPotionEffectsEnabled", true);
            this.bossPotionEffects = builder.comment(new String[]{"List of mob effects for boss mobs, format: 'namespace:effect:amplifier:durationTicks'.", "Example: ['minecraft:strength:2:999999','minecraft:resistance:1:999999']"}).defineList("bossPotionEffects", List.of("minecraft:strength:2:999999", "minecraft:resistance:1:999999"), o -> o instanceof String);
            builder.pop();
            builder.push("debug");
            this.debugLoggingEnabled = builder.comment(new String[]{"If true, enables detailed debug logging for WaveSpawnerBlockEntity.", "WARNING: Can generate A LOT of logs! Use only for debugging."}).define("debugLoggingEnabled", false);
            builder.pop();
        }
    }
}

