/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.dungeonblocks.network;

import com.everydayxp.dungeonblocks.client.ClientBossData;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class BossInfoS2CPacket {
    private final BlockPos pos;
    private final boolean active;
    private final int timeTicks;

    public BossInfoS2CPacket(BlockPos pos, boolean active, int timeTicks) {
        this.pos = pos;
        this.active = active;
        this.timeTicks = timeTicks;
    }

    public static void encode(BossInfoS2CPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.writeBoolean(msg.active);
        buf.writeInt(msg.timeTicks);
    }

    public static BossInfoS2CPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        boolean active = buf.readBoolean();
        int timeTicks = buf.readInt();
        return new BossInfoS2CPacket(pos, active, timeTicks);
    }

    public static void handle(BossInfoS2CPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            double distSqr;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null || mc.f_91074_ == null) {
                return;
            }
            if (msg.active && (distSqr = mc.f_91074_.m_20238_(msg.pos.m_252807_())) > 144.0) {
                return;
            }
            ClientBossData.set(msg.pos, msg.active, msg.timeTicks);
        }));
        ctx.get().setPacketHandled(true);
    }
}

