/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.dungeonblocks.network;

import com.everydayxp.dungeonblocks.client.ClientWaveData;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class WaveInfoS2CPacket {
    private final BlockPos pos;
    private final boolean active;
    private final int currentWave;
    private final int totalWaves;
    private final int mobsAlive;

    public WaveInfoS2CPacket(BlockPos pos, boolean active, int currentWave, int totalWaves, int mobsAlive) {
        this.pos = pos;
        this.active = active;
        this.currentWave = currentWave;
        this.totalWaves = totalWaves;
        this.mobsAlive = mobsAlive;
    }

    public static void encode(WaveInfoS2CPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.writeBoolean(msg.active);
        buf.writeInt(msg.currentWave);
        buf.writeInt(msg.totalWaves);
        buf.writeInt(msg.mobsAlive);
    }

    public static WaveInfoS2CPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        boolean active = buf.readBoolean();
        int currentWave = buf.readInt();
        int totalWaves = buf.readInt();
        int mobsAlive = buf.readInt();
        return new WaveInfoS2CPacket(pos, active, currentWave, totalWaves, mobsAlive);
    }

    public static void handle(WaveInfoS2CPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null || mc.f_91074_ == null) {
                return;
            }
            double distSqr = mc.f_91074_.m_20238_(msg.pos.m_252807_());
            if (distSqr > 144.0) {
                return;
            }
            ClientWaveData.set(msg.pos, msg.active, msg.currentWave, msg.totalWaves, msg.mobsAlive);
        }));
        ctx.get().setPacketHandled(true);
    }
}

