/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.dungeonblocks.util;

import com.everydayxp.dungeonblocks.config.DungeonBlocksConfig;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DungeonBlocksJsonConfig {
    private static final Gson GSON = new Gson();
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean DEBUG_LOG = false;
    public static List<EntityType<?>> WAVE_EXTRA_ENTITIES = List.of();
    public static List<EntityType<?>> BOSS_ENTITIES = List.of();
    public static final Map<String, Integer> WAVE_BIOME_GROUPS = new HashMap<String, Integer>();
    public static final List<GroupedEntity> WAVE_GROUPED_ENTITIES = new ArrayList<GroupedEntity>();
    public static final List<BossEntity> BOSS_CONFIG = new ArrayList<BossEntity>();
    private static final String[] FILES = new String[]{"waves.json", "bosses.json"};

    public static void init() {
        DEBUG_LOG = (Boolean)DungeonBlocksConfig.COMMON.debugLoggingEnabled.get();
        DungeonBlocksJsonConfig.debugLog("JsonConfig.init() llamado. CONFIGDIR = {}", FMLPaths.CONFIGDIR.get());
        for (String fileName : FILES) {
            DungeonBlocksJsonConfig.copyDefaultConfigIfMissing(fileName);
        }
        DungeonBlocksJsonConfig.load(FMLPaths.CONFIGDIR.get());
        DungeonBlocksJsonConfig.debugLog("JsonConfig init: waves_groups={} grouped={} bosses_config={} legacy_bosses={}", WAVE_BIOME_GROUPS.size(), WAVE_GROUPED_ENTITIES.size(), BOSS_CONFIG.size(), BOSS_ENTITIES.size());
        WAVE_BIOME_GROUPS.forEach((biome, group) -> DungeonBlocksJsonConfig.debugLog("Biome group: {} -> {}", biome, group));
        WAVE_GROUPED_ENTITIES.forEach(ge -> DungeonBlocksJsonConfig.debugLog("Wave entity: {} (group {})", ge.id, ge.group));
        BOSS_CONFIG.forEach(boss -> DungeonBlocksJsonConfig.debugLog("Boss config: {} (bossbar={})", boss.id, boss.bossbar));
        BOSS_ENTITIES.forEach(type -> DungeonBlocksJsonConfig.debugLog("Legacy boss: {}", ForgeRegistries.ENTITY_TYPES.getKey(type)));
    }

    private static void debugLog(String message, Object ... args) {
        if (DEBUG_LOG) {
            LOGGER.info("[DungeonBlocks] " + message, args);
        }
    }

    private static void copyDefaultConfigIfMissing(String fileName) {
        File configDir = FMLPaths.CONFIGDIR.get().toFile();
        File configFile = new File(configDir, "dungeonblocks/" + fileName);
        if (configFile.exists()) {
            DungeonBlocksJsonConfig.debugLog("Config ya existe: {}", configFile.getAbsolutePath());
            return;
        }
        configFile.getParentFile().mkdirs();
        String internalPath = "/config/dungeonblocks/" + fileName;
        try (InputStream in = DungeonBlocksJsonConfig.class.getResourceAsStream(internalPath);
             FileOutputStream out = new FileOutputStream(configFile);){
            if (in != null) {
                int len;
                byte[] buffer = new byte[4096];
                while ((len = in.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
                DungeonBlocksJsonConfig.debugLog("Default config copiada: {}", configFile.getAbsolutePath());
            } else {
                LOGGER.warn("[DungeonBlocks] Default resource no encontrado: {}", (Object)internalPath);
            }
        }
        catch (Exception e) {
            LOGGER.error("[DungeonBlocks] Error copying config {}: {}", (Object)configFile.getAbsolutePath(), (Object)e.getMessage());
        }
    }

    public static void load(Path configDir) {
        File folder = configDir.resolve("dungeonblocks").toFile();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File wavesFile = new File(folder, "waves.json");
        File bossesFile = new File(folder, "bosses.json");
        DungeonBlocksJsonConfig.debugLog("Loading: {}", wavesFile.getAbsolutePath());
        DungeonBlocksJsonConfig.debugLog("Loading: {}", bossesFile.getAbsolutePath());
        DungeonBlocksJsonConfig.loadWavesBiomeGroups(wavesFile);
        DungeonBlocksJsonConfig.loadBossConfig(bossesFile);
        WAVE_EXTRA_ENTITIES = DungeonBlocksJsonConfig.loadEntityList(wavesFile, "extra_entities");
        BOSS_ENTITIES = DungeonBlocksJsonConfig.loadEntityList(bossesFile, "boss_entities");
        DungeonBlocksJsonConfig.debugLog("Load complete: waves={} bosses_config={} legacy={}", WAVE_BIOME_GROUPS.size(), BOSS_CONFIG.size(), BOSS_ENTITIES.size());
    }

    private static void loadWavesBiomeGroups(File file) {
        WAVE_BIOME_GROUPS.clear();
        WAVE_GROUPED_ENTITIES.clear();
        if (!file.exists()) {
            LOGGER.warn("[DungeonBlocks] waves.json not found: {}", (Object)file.getAbsolutePath());
            return;
        }
        try (FileReader reader = new FileReader(file);){
            JsonObject obj = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (obj == null) {
                return;
            }
            if (obj.has("biome_groups") && obj.get("biome_groups").isJsonObject()) {
                obj.getAsJsonObject("biome_groups").entrySet().forEach(entry -> {
                    try {
                        WAVE_BIOME_GROUPS.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                    }
                    catch (Exception e) {
                        LOGGER.warn("Invalid biome_group: {}={}", entry.getKey(), entry.getValue());
                    }
                });
            }
            if (obj.has("entities") && obj.get("entities").isJsonArray()) {
                JsonArray entitiesArray = obj.getAsJsonArray("entities");
                for (int i = 0; i < entitiesArray.size(); ++i) {
                    try {
                        GroupedEntity ge = (GroupedEntity)GSON.fromJson(entitiesArray.get(i), GroupedEntity.class);
                        if (ge == null || ge.id == null || ge.id.isEmpty() || ge.group < 0) continue;
                        WAVE_GROUPED_ENTITIES.add(ge);
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.warn("[DungeonBlocks] Invalid wave entity[{}]: {}", (Object)i, (Object)e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[DungeonBlocks] Error loading waves.json: {}", (Object)e.getMessage());
        }
    }

    private static void loadBossConfig(File file) {
        BOSS_CONFIG.clear();
        if (!file.exists()) {
            LOGGER.warn("[DungeonBlocks] bosses.json not found: {}", (Object)file.getAbsolutePath());
            return;
        }
        try (FileReader reader = new FileReader(file);){
            JsonObject obj = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (obj == null || !obj.has("bosses") || !obj.get("bosses").isJsonArray()) {
                LOGGER.warn("[DungeonBlocks] 'bosses' array missing in bosses.json");
                return;
            }
            JsonArray bossesArray = obj.getAsJsonArray("bosses");
            for (int i = 0; i < bossesArray.size(); ++i) {
                try {
                    BossEntity boss = (BossEntity)GSON.fromJson(bossesArray.get(i), BossEntity.class);
                    if (boss == null || boss.id == null || boss.id.isEmpty()) continue;
                    BOSS_CONFIG.add(boss);
                    DungeonBlocksJsonConfig.debugLog("Loaded boss[{}]: {} (bossbar={})", i, boss.id, boss.bossbar);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.warn("[DungeonBlocks] Invalid boss[{}]: {}", (Object)i, (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[DungeonBlocks] Error loading bosses.json: {}", (Object)e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<EntityType<?>> loadEntityList(File file, String arrayKey) {
        ArrayList result = new ArrayList();
        if (!file.exists()) {
            return result;
        }
        try (FileReader reader = new FileReader(file);){
            JsonObject obj = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (obj == null || !obj.has(arrayKey) || !obj.get(arrayKey).isJsonArray()) {
                ArrayList arrayList = result;
                return arrayList;
            }
            obj.getAsJsonArray(arrayKey).forEach(elem -> {
                if (!elem.isJsonPrimitive() || !elem.getAsJsonPrimitive().isString()) {
                    return;
                }
                String idStr = elem.getAsString();
                try {
                    ResourceLocation id = new ResourceLocation(idStr);
                    EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(id);
                    if (type != null) {
                        result.add(type);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            return result;
        }
        catch (Exception e) {
            LOGGER.error("Failed to load {}: {}", (Object)file.getPath(), (Object)e.getMessage());
        }
        return result;
    }

    public static class GroupedEntity {
        public String id;
        public int group;
    }

    public static class BossEntity {
        public String id;
        public boolean bossbar = true;
    }
}

