/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixwb.darkhours;

import com.phoenixwb.darkhours.block.BlockInit;
import com.phoenixwb.darkhours.blockentity.BlockEntityInit;
import com.phoenixwb.darkhours.data.AttachmentInit;
import com.phoenixwb.darkhours.data.TimeProperty;
import com.phoenixwb.darkhours.effect.MobEffectInit;
import com.phoenixwb.darkhours.effect.PotionInit;
import com.phoenixwb.darkhours.entity.EntityInit;
import com.phoenixwb.darkhours.item.ItemInit;
import com.phoenixwb.darkhours.networking.SetDarkHourClear;
import com.phoenixwb.darkhours.util.DHConfig;
import com.phoenixwb.darkhours.util.DHTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.network.PacketDistributor;

@Mod(value="darkhours")
public class DarkHours {
    public static final String MODID = "darkhours";

    public DarkHours(IEventBus modEventBus, ModContainer modContainer) {
        ItemInit.ITEMS.register(modEventBus);
        BlockInit.BLOCKS.register(modEventBus);
        BlockEntityInit.BLOCK_ENTITIES.register(modEventBus);
        MobEffectInit.MOB_EFFECTS.register(modEventBus);
        PotionInit.POTIONS.register(modEventBus);
        AttachmentInit.ATTACHMENT_TYPES.register(modEventBus);
        EntityInit.ENTITY_TYPES.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DHConfig.SPEC);
    }

    public static void setPendulumTime(ServerLevel level, long time) {
        ((TimeProperty)level.getData(AttachmentInit.TIME_PROPERTY)).setTime(time);
        ((TimeProperty)level.getData(AttachmentInit.TIME_PROPERTY)).setActive(true);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SetDarkHourClear(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static boolean isForestBiome(Holder<Biome> biome) {
        return biome.is(BiomeTags.IS_OVERWORLD) && biome.is(DHTags.DARK_HOUR);
    }

    public static boolean checkDarkHoursSpawnRules(EntityType<? extends Monster> type, ServerLevelAccessor accessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        ServerLevel level = accessor.getServer().overworld();
        long time = level.getDayTime() % 24000L;
        return Monster.checkMonsterSpawnRules(type, (ServerLevelAccessor)accessor.getLevel(), (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && time >= 17800L && time <= 22300L && level.getGameTime() - ((TimeProperty)level.getData(AttachmentInit.TIME_PROPERTY)).getTime() > DHConfig.realityGearDuration;
    }
}

