/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixwb.darkhours.entity;

import com.phoenixwb.darkhours.effect.MobEffectInit;
import com.phoenixwb.darkhours.entity.DisappearingMonster;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ForestClock
extends DisappearingMonster
implements GeoEntity {
    private static final EntityDataAccessor<Byte> REWINDING_STATE_ID = SynchedEntityData.defineId(ForestClock.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("animation.forest_clock.idle");
    protected static final RawAnimation REWIND_ANIM = RawAnimation.begin().thenLoop("animation.forest_clock.rewind");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int clockTickThreshold = this.level().getRandom().nextInt(300, 401);
    boolean shouldDiscard = false;
    boolean canTarget = true;

    public ForestClock(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.targetSelector.addGoal(1, (Goal)new ForestClockNearestRingableGoal());
        this.goalSelector.addGoal(2, (Goal)new ForestClockLookAtTargetGoal());
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.FOLLOW_RANGE, 15.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide() && this.shouldDiscard) {
            this.playSound(SoundEvents.WOOD_BREAK);
            this.level().levelEvent(null, 2001, this.blockPosition(), Block.getId((BlockState)Blocks.DARK_OAK_WOOD.defaultBlockState()));
            this.discard();
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || source.is(DamageTypeTags.IS_FIRE)) {
            return super.hurt(source, amount);
        }
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    protected <E extends ForestClock> PlayState predicate(AnimationState<E> event) {
        if (this.isRewinding()) {
            return event.setAndContinue(REWIND_ANIM);
        }
        return event.setAndContinue(IDLE_ANIM);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void setRewinding(boolean rewinding) {
        this.entityData.set(REWINDING_STATE_ID, (Object)((byte)(rewinding ? 1 : 0)));
    }

    public boolean isRewinding() {
        return (Byte)this.entityData.get(REWINDING_STATE_ID) == 1;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.BELL_RESONATE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(REWINDING_STATE_ID, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("shouldDiscard", this.shouldDiscard);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.shouldDiscard = compound.getBoolean("shouldDiscard");
    }

    class ForestClockNearestRingableGoal
    extends NearestAttackableTargetGoal<Player> {
        public ForestClockNearestRingableGoal() {
            super((Mob)ForestClock.this, Player.class, false);
        }

        public boolean canUse() {
            return super.canUse() && !this.target.hasEffect(MobEffectInit.COUNT_DOWN) && ForestClock.this.canTarget;
        }

        public boolean canContinueToUse() {
            boolean canContinue;
            boolean bl = canContinue = ForestClock.this.getTarget() != null && ForestClock.this.getTarget().isAlive() && ForestClock.this.getTarget().hasEffect(MobEffectInit.COUNT_DOWN);
            if (!canContinue) {
                ForestClock.this.shouldDiscard = true;
            }
            return canContinue;
        }

        public void start() {
            super.start();
            ForestClock.this.setRewinding(true);
            this.target.addEffect(new MobEffectInstance(MobEffectInit.COUNT_DOWN, ForestClock.this.clockTickThreshold), (Entity)ForestClock.this);
            ForestClock.this.canTarget = false;
        }
    }

    class ForestClockLookAtTargetGoal
    extends Goal {
        ForestClockLookAtTargetGoal() {
        }

        public boolean canUse() {
            if (ForestClock.this.getTarget() != null) {
                ForestClock.this.lookAt(EntityAnchorArgument.Anchor.EYES, ForestClock.this.getTarget().getEyePosition());
            }
            return ForestClock.this.getTarget() != null;
        }
    }
}

