/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixwb.darkhours.entity;

import com.phoenixwb.darkhours.effect.MobEffectInit;
import com.phoenixwb.darkhours.entity.DisappearingMonster;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Lumber
extends DisappearingMonster
implements GeoEntity {
    public static final ResourceKey<LootTable> LOOT_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"darkhours", (String)"entities/lumber"));
    private static final EntityDataAccessor<Byte> PEAKING_STATE_ID = SynchedEntityData.defineId(Lumber.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("animation.lumber.idle");
    protected static final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("animation.lumber.walk");
    protected static final RawAnimation PEEK_ANIM = RawAnimation.begin().thenPlay("animation.lumber.peek");
    protected static final RawAnimation UNPEEK_ANIM = RawAnimation.begin().thenPlay("animation.lumber.unpeek");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected int peakCooldown;
    protected int peakTicks;
    protected int unpeakTicks;

    public Lumber(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.resetPeekTiming();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new LumberAttackGoal(1.2f, false));
        this.goalSelector.addGoal(3, (Goal)new LumberPeekGoal());
        this.goalSelector.addGoal(4, (Goal)new LumberWaterAvoidingRandomStrollGoal(1.0));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 20.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new LumberNearestAttackableTargetGoal());
        this.targetSelector.addGoal(2, (Goal)new LumberNearestPeekableTargetGoal());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 120.0).add(Attributes.MOVEMENT_SPEED, 0.15).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.STEP_HEIGHT, 2.0);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            if (this.peakCooldown > 0) {
                --this.peakCooldown;
            }
            if (this.getPeakingState() == PeakingState.PEAKING.val) {
                ++this.peakTicks;
            } else if (this.peakTicks > 0) {
                this.peakTicks = 0;
            }
            if (this.getPeakingState() == PeakingState.UNPEAKING.val) {
                ++this.unpeakTicks;
                if (this.unpeakTicks >= 30) {
                    this.setPeakingState(PeakingState.NOT_PEAKING);
                    this.unpeakTicks = 0;
                }
            }
            if (!this.isRemoved()) {
                this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.8), EntitySelector.NO_SPECTATORS.and(entity -> {
                    LivingEntity living;
                    return entity instanceof LivingEntity && !((living = (LivingEntity)entity) instanceof Lumber) && !living.hasEffect(MobEffectInit.DIGESTION);
                })).forEach(entity -> ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffectInit.DIGESTION, 80, 0)));
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    protected <E extends Lumber> PlayState predicate(AnimationState<E> event) {
        if (this.getPeakingState() == PeakingState.PEAKING.val) {
            return event.setAndContinue(PEEK_ANIM);
        }
        if (this.getPeakingState() == PeakingState.UNPEAKING.val) {
            return event.setAndContinue(UNPEEK_ANIM);
        }
        if (event.isMoving()) {
            return event.setAndContinue(WALK_ANIM);
        }
        return event.setAndContinue(IDLE_ANIM);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void setPeakingState(PeakingState peakingState) {
        this.entityData.set(PEAKING_STATE_ID, (Object)peakingState.val);
    }

    public byte getPeakingState() {
        return (Byte)this.entityData.get(PEAKING_STATE_ID);
    }

    public void resetPeekTiming() {
        this.peakCooldown = this.level().getRandom().nextInt(400, 601);
        this.peakTicks = 0;
        this.unpeakTicks = 0;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.SCULK_BLOCK_PLACE;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.MAGMA_CUBE_JUMP;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.BEACON_DEACTIVATE;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(SoundEvents.SLIME_JUMP, 0.15f, 1.0f);
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return LOOT_TABLE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PEAKING_STATE_ID, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("peakCooldown", this.peakCooldown);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.peakCooldown = compound.getInt("peakCooldown");
    }

    class LumberAttackGoal
    extends MeleeAttackGoal {
        public LumberAttackGoal(double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super((PathfinderMob)Lumber.this, speedModifier, followingTargetEvenIfNotSeen);
        }

        protected boolean canPerformAttack(LivingEntity entity) {
            return Lumber.this.getPeakingState() == PeakingState.NOT_PEAKING.val && this.isTimeToAttack() && Lumber.this.position().subtract(entity.position()).length() <= 12.0 && !entity.hasEffect(MobEffectInit.MENTAL_LOAD);
        }

        protected void checkAndPerformAttack(LivingEntity target) {
            if (this.canPerformAttack(target)) {
                this.resetAttackCooldown();
                target.addEffect(new MobEffectInstance(MobEffectInit.MENTAL_LOAD, 200, 0));
                this.mob.playSound(SoundEvents.CONDUIT_DEACTIVATE, 1.0f, 0.87f);
                if (target instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)target;
                    player.playNotifySound(SoundEvents.CAT_HISS, SoundSource.HOSTILE, 1.0f, 0.52f);
                }
            }
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = this.adjustedTickDelay(260);
        }
    }

    class LumberPeekGoal
    extends Goal {
        private int searchTicks = 150;

        LumberPeekGoal() {
        }

        public boolean canUse() {
            return Lumber.this.getTarget() == null && Lumber.this.peakCooldown == 0 && Lumber.this.level().getBlockStates(this.getAABB()).anyMatch(state -> !state.isAir());
        }

        public boolean canContinueToUse() {
            return Lumber.this.getTarget() == null && this.searchTicks > 0;
        }

        public void tick() {
            super.tick();
            --this.searchTicks;
        }

        public void start() {
            super.start();
            this.searchTicks = 150;
            Lumber.this.setPeakingState(PeakingState.PEAKING);
        }

        public void stop() {
            super.stop();
            Lumber.this.resetPeekTiming();
            Lumber.this.setPeakingState(PeakingState.UNPEAKING);
            LivingEntity target = Lumber.this.getTarget();
            if (target != null) {
                Lumber.this.playSound(SoundEvents.SCULK_CLICKING);
                if (target instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)target;
                    player.playNotifySound(SoundEvents.WARDEN_HEARTBEAT, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }

        private AABB getAABB() {
            BlockPos pos = Lumber.this.blockPosition().above(2);
            return new AABB((double)(pos.getX() - 2), (double)pos.getY(), (double)(pos.getZ() - 2), (double)(pos.getX() + 3), (double)(pos.getY() + 3), (double)(pos.getZ() + 3));
        }
    }

    class LumberWaterAvoidingRandomStrollGoal
    extends WaterAvoidingRandomStrollGoal {
        public LumberWaterAvoidingRandomStrollGoal(double speedModifier) {
            super((PathfinderMob)Lumber.this, speedModifier);
        }

        public boolean canUse() {
            return super.canUse() && Lumber.this.getPeakingState() == PeakingState.NOT_PEAKING.val;
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && Lumber.this.getPeakingState() == PeakingState.NOT_PEAKING.val;
        }
    }

    class LumberNearestAttackableTargetGoal
    extends NearestAttackableTargetGoal<Player> {
        public LumberNearestAttackableTargetGoal() {
            super((Mob)Lumber.this, Player.class, true);
            this.unseenMemoryTicks = 240;
        }

        public boolean canUse() {
            return Lumber.this.getPeakingState() == PeakingState.NOT_PEAKING.val && super.canUse();
        }

        public boolean canContinueToUse() {
            return Lumber.this.getPeakingState() == PeakingState.NOT_PEAKING.val && super.canContinueToUse();
        }
    }

    class LumberNearestPeekableTargetGoal
    extends NearestAttackableTargetGoal<Player> {
        public LumberNearestPeekableTargetGoal() {
            super((Mob)Lumber.this, Player.class, false);
            this.targetConditions = TargetingConditions.forCombat().ignoreLineOfSight().range(6.0).selector(living -> living.blockPosition().getY() <= Lumber.this.blockPosition().above(2).getY());
        }

        public boolean canUse() {
            return Lumber.this.peakTicks >= 70 && super.canUse();
        }
    }

    public static enum PeakingState {
        NOT_PEAKING(0),
        PEAKING(1),
        UNPEAKING(2);

        final byte val;

        private PeakingState(byte val) {
            this.val = val;
        }
    }
}

