/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixwb.darkhours.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.phoenixwb.darkhours.DarkHours;
import com.phoenixwb.darkhours.client.DHClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.FogType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

@EventBusSubscriber(modid="darkhours", value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void onRejoin(EntityJoinLevelEvent event) {
        if (event.getLevel().isClientSide()) {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.player.is(event.getEntity())) {
                DHClient.fogTick = 0;
                DHClient.strength = 0;
            }
        }
    }

    @SubscribeEvent
    public static void clientTick(ClientTickEvent.Post event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level != null) {
            long time = minecraft.level.getDayTime() % 24000L;
            if (DarkHours.isForestBiome((Holder<Biome>)minecraft.level.getBiome(minecraft.player.blockPosition())) && time >= 17800L && time <= 22300L && !DHClient.isDarkHourClear) {
                if (DHClient.fogTick < 15) {
                    ++DHClient.fogTick;
                }
            } else if (DHClient.fogTick > 0) {
                --DHClient.fogTick;
            }
            if (DHClient.strength > 0) {
                --DHClient.strength;
            }
        }
    }

    @SubscribeEvent
    public static void onFogRender(ViewportEvent.RenderFog event) {
        FogType type = event.getType();
        Entity entity = event.getCamera().getEntity();
        if (DHClient.fogTick > 0 && type != FogType.LAVA && type != FogType.POWDER_SNOW && FogRenderer.getPriorityFogFunction((Entity)entity, (float)((float)event.getPartialTick())) == null && type != FogType.WATER) {
            float f = Mth.lerp((float)((float)DHClient.fogTick / 15.0f), (float)event.getFarPlaneDistance(), (float)27.0f);
            if (event.getMode() == FogRenderer.FogMode.FOG_SKY) {
                RenderSystem.setShaderFogStart((float)0.0f);
                RenderSystem.setShaderFogEnd((float)(f * 0.5f));
            } else {
                RenderSystem.setShaderFogStart((float)(f * 0.36f));
                RenderSystem.setShaderFogEnd((float)f);
            }
        }
    }
}

