/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixwb.darkhours.events;

import com.phoenixwb.darkhours.DarkHours;
import com.phoenixwb.darkhours.block.BlockInit;
import com.phoenixwb.darkhours.data.AttachmentInit;
import com.phoenixwb.darkhours.data.SavedPositions;
import com.phoenixwb.darkhours.data.TimeProperty;
import com.phoenixwb.darkhours.effect.MobEffectInit;
import com.phoenixwb.darkhours.effect.PotionInit;
import com.phoenixwb.darkhours.entity.ForestClock;
import com.phoenixwb.darkhours.item.ItemInit;
import com.phoenixwb.darkhours.networking.SetDarkHourClear;
import com.phoenixwb.darkhours.networking.SetTDMStrength;
import com.phoenixwb.darkhours.util.DHConfig;
import com.phoenixwb.darkhours.util.DHTags;
import com.phoenixwb.darkhours.util.DHUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="darkhours")
public class GameEvents {
    @SubscribeEvent
    public static void onJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerLevel level;
            ServerPlayer player = (ServerPlayer)entity;
            SavedPositions positions = (SavedPositions)player.getData(AttachmentInit.SAVED_POSITIONS);
            if (positions.getCountdownPos() == null) {
                positions.setCountdownPos(player.blockPosition());
            }
            if (positions.getTimeManifestPos() == null) {
                positions.setTimeManifestPos(player.blockPosition());
            }
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SetDarkHourClear((level = player.getServer().overworld()).getGameTime() - ((TimeProperty)level.getData(AttachmentInit.TIME_PROPERTY)).getTime() <= DHConfig.realityGearDuration), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ((SavedPositions)player2.getData(AttachmentInit.SAVED_POSITIONS)).setCountdownPos(player2.blockPosition());
        }
    }

    @SubscribeEvent
    public static void rightClickEntity(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (event.getTarget() instanceof ForestClock && event.getItemStack().is(Items.CLOCK) && player2.experienceLevel >= 1) {
                event.getItemStack().shrink(1);
                player2.addItem(((Item)ItemInit.ENCHANTED_CLOCK.get()).getDefaultInstance());
                player2.giveExperienceLevels(-1);
            }
        }
    }

    @SubscribeEvent
    public static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            Block block;
            ServerPlayer player2 = (ServerPlayer)player;
            BlockPos pos = event.getHitVec().getBlockPos();
            BlockState state = player2.level().getBlockState(pos);
            ItemStack item = event.getItemStack();
            if (item.is(ItemInit.TIME_DENSITY_MANIFEST) && state.is(BlockInit.REALITY_GEAR)) {
                DarkHours.setPendulumTime(player2.getServer().overworld(), player2.level().getGameTime());
                player2.serverLevel().players().forEach(play -> play.playNotifySound(SoundEvents.BELL_BLOCK, SoundSource.WEATHER, 1.0f, 1.0f));
                event.getItemStack().shrink(1);
            }
            if (item.is(ItemInit.LUMBER_GOO) && (block = state.getBlock()) instanceof WeatheringCopper) {
                Optional<BlockState> next;
                WeatheringCopper weathering = (WeatheringCopper)block;
                BlockState state2 = state;
                for (int i = 0; i < 3 && (next = WeatheringCopper.getNext((Block)state2.getBlock()).map(DHUtil.withBlockStateProperties(state2))).isPresent(); ++i) {
                    state2 = next.get();
                }
                if (state2 != state) {
                    player2.level().setBlockAndUpdate(pos, state2);
                    item.shrink(1);
                    player2.level().playSound(null, pos, SoundEvents.SLIME_BLOCK_PLACE, SoundSource.BLOCKS);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartedEvent event) {
        ServerLevel level = event.getServer().overworld();
        TimeProperty time = (TimeProperty)level.getData(AttachmentInit.TIME_PROPERTY);
        if (time.getTime() == null) {
            time.setTime(-DHConfig.realityGearDuration);
        }
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        ServerLevel level = event.getServer().overworld();
        if (level.getGameTime() % 70L == 0L && ((TimeProperty)level.getData(AttachmentInit.TIME_PROPERTY)).active()) {
            TimeProperty timeProp = (TimeProperty)level.getData(AttachmentInit.TIME_PROPERTY);
            if (level.getGameTime() - timeProp.getTime() > DHConfig.realityGearDuration) {
                timeProp.setActive(false);
                level.players().forEach(player -> {
                    player.playNotifySound(SoundEvents.BELL_BLOCK, SoundSource.WEATHER, 1.0f, 0.5f);
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SetDarkHourClear(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                });
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.tickCount % 120 == 0) {
                long time;
                SavedPositions savePos = (SavedPositions)player2.getData(AttachmentInit.SAVED_POSITIONS);
                if (!player2.hasEffect(MobEffectInit.COUNT_DOWN) && !DarkHours.isForestBiome((Holder<Biome>)player2.level().getBiome(player2.blockPosition()))) {
                    savePos.setCountdownPos(player2.blockPosition());
                }
                if ((time = player2.level().getDayTime() % 24000L) >= 14000L && time <= 22300L && (player2.getItemInHand(InteractionHand.MAIN_HAND).is(ItemInit.TIME_DENSITY_MANIFEST) || player2.getItemInHand(InteractionHand.OFF_HAND).is(ItemInit.TIME_DENSITY_MANIFEST)) && !player2.blockPosition().equals((Object)savePos.getTimeManifestPos())) {
                    BlockPos manifestPos = savePos.getTimeManifestPos();
                    BlockPos blockPos = player2.serverLevel().findNearestMapStructure(DHTags.CLOCK_TOWER, manifestPos, 100, false);
                    double s0 = Math.PI;
                    if (blockPos != null) {
                        Vec3 vec3 = Vec3.atCenterOf((Vec3i)blockPos.subtract((Vec3i)manifestPos)).normalize();
                        Vec3 vecPlayer = Vec3.atCenterOf((Vec3i)player2.blockPosition().subtract((Vec3i)manifestPos)).normalize();
                        s0 = Math.acos(vecPlayer.x() * vec3.x() + vecPlayer.z() * vec3.z());
                    }
                    for (ForestClock clock : player2.level().getEntitiesOfClass(ForestClock.class, new AABB(manifestPos).inflate(20.0))) {
                        Vec3 vec3 = Vec3.atCenterOf((Vec3i)clock.blockPosition().subtract((Vec3i)manifestPos)).normalize();
                        Vec3 vecPlayer = Vec3.atCenterOf((Vec3i)player2.blockPosition().subtract((Vec3i)manifestPos)).normalize();
                        double s1 = Math.acos(vecPlayer.x() * vec3.x() + vecPlayer.z() * vec3.z());
                        if (!(s1 < s0)) continue;
                        s0 = s1;
                    }
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SetTDMStrength((int)Math.round(Math.pow(Math.E, 1.39878 * (Math.PI - s0)) - 1.0)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                savePos.setTimeManifestPos(player2.blockPosition());
            }
        }
    }

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        LivingEntity entity = event.getEntity();
        if (!entity.level().isClientSide() && event.getEffectInstance().is(MobEffectInit.COUNT_DOWN) && !(event.getEffectSource() instanceof ForestClock)) {
            ((SavedPositions)entity.getData(AttachmentInit.SAVED_POSITIONS)).setCountdownPos(event.getEntity().blockPosition());
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        LivingEntity entity = event.getEntity();
        if (!entity.level().isClientSide() && event.getEffectInstance().is(MobEffectInit.COUNT_DOWN)) {
            BlockPos telepos = ((SavedPositions)entity.getData(AttachmentInit.SAVED_POSITIONS)).getCountdownPos();
            entity.teleportTo((double)telepos.getX() + 0.5, (double)telepos.getY(), (double)telepos.getZ() + 0.5);
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        LivingEntity entity = event.getEntity();
        if (!entity.level().isClientSide() && event.getEffectInstance().is(MobEffectInit.COUNT_DOWN)) {
            BlockPos telepos = ((SavedPositions)entity.getData(AttachmentInit.SAVED_POSITIONS)).getCountdownPos();
            entity.teleportTo((double)telepos.getX() + 0.5, (double)telepos.getY(), (double)telepos.getZ() + 0.5);
        }
    }

    @SubscribeEvent
    public static void onRegisterBrewingRecipes(RegisterBrewingRecipesEvent event) {
        event.getBuilder().addMix(Potions.AWKWARD, (Item)ItemInit.ENCHANTED_CLOCK.get(), PotionInit.REWINDING_POTION);
        event.getBuilder().addMix(PotionInit.REWINDING_POTION, Items.REDSTONE, PotionInit.LONG_REWINDING_POTION);
    }
}

