/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixwb.darkhours.events;

import com.phoenixwb.darkhours.DarkHours;
import com.phoenixwb.darkhours.blockentity.BlockEntityInit;
import com.phoenixwb.darkhours.client.DHClient;
import com.phoenixwb.darkhours.client.EnchantedClockPropertyFunction;
import com.phoenixwb.darkhours.effect.MentalLoadFogFunction;
import com.phoenixwb.darkhours.entity.EntityInit;
import com.phoenixwb.darkhours.entity.ForestClock;
import com.phoenixwb.darkhours.entity.Lumber;
import com.phoenixwb.darkhours.geckolib.renderer.ForestClockRenderer;
import com.phoenixwb.darkhours.geckolib.renderer.LumberRenderer;
import com.phoenixwb.darkhours.geckolib.renderer.RealityGearRenderer;
import com.phoenixwb.darkhours.item.ItemInit;
import com.phoenixwb.darkhours.networking.SetDarkHourClear;
import com.phoenixwb.darkhours.networking.SetTDMStrength;
import com.phoenixwb.darkhours.networking.UseLumberingEye;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="darkhours", bus=EventBusSubscriber.Bus.MOD)
public class ModEvents {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        EntityRenderers.register((EntityType)((EntityType)EntityInit.LUMBER.get()), LumberRenderer::new);
        EntityRenderers.register((EntityType)((EntityType)EntityInit.FOREST_CLOCK.get()), ForestClockRenderer::new);
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)BlockEntityInit.REALITY_GEAR.get()), context -> new RealityGearRenderer());
        FogRenderer.MOB_EFFECT_FOG.add(new MentalLoadFogFunction());
        event.enqueueWork(() -> ItemProperties.register((Item)((Item)ItemInit.ENCHANTED_CLOCK.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"darkhours", (String)"time"), (ItemPropertyFunction)new EnchantedClockPropertyFunction()));
    }

    @SubscribeEvent
    public static void registerItemColours(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tint) -> {
            if (tint == 1) {
                return 0xFF490000 | DHClient.strength * 2 + 85 << 8 | 0x4B;
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ItemInit.TIME_DENSITY_MANIFEST.get()});
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)EntityInit.LUMBER.get(), Lumber.createAttributes().build());
        event.put((EntityType)EntityInit.FOREST_CLOCK.get(), ForestClock.createAttributes().build());
    }

    @SubscribeEvent
    public static void onSpawnEntityRestrict(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)EntityInit.LUMBER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, DarkHours::checkDarkHoursSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        event.register((EntityType)EntityInit.FOREST_CLOCK.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, DarkHours::checkDarkHoursSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
    }

    @SubscribeEvent
    public static void addItemsToCreativeModeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.accept(ItemInit.ENCHANTED_CLOCK);
        } else if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept(ItemInit.TIME_DENSITY_MANIFEST);
            event.accept(ItemInit.LUMBER_GOO);
        } else if (event.getTabKey() == CreativeModeTabs.COMBAT) {
            event.accept(ItemInit.LUMBERING_EYE);
        } else if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS || event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            event.accept(ItemInit.REALITY_GEAR);
        } else if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            event.accept(ItemInit.LUMBER_SPAWN_EGG);
            event.accept(ItemInit.FOREST_CLOCK_SPAWN_EGG);
        }
    }

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(SetTDMStrength.TYPE, SetTDMStrength.STREAM_CODEC, (IPayloadHandler)new SetTDMStrength.ClientPayloadHandler());
        registrar.playToClient(SetDarkHourClear.TYPE, SetDarkHourClear.STREAM_CODEC, (IPayloadHandler)new SetDarkHourClear.ClientPayloadHandler());
        registrar.playToServer(UseLumberingEye.TYPE, UseLumberingEye.STREAM_CODEC, (IPayloadHandler)new UseLumberingEye.ServerPayloadHandler());
    }
}

