/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixwb.darkhours.mixin;

import com.phoenixwb.darkhours.entity.Lumber;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Projectile.class})
public abstract class MixinProjectile
extends Entity {
    public MixinProjectile(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/world/entity/projectile/Projectile;onHit(Lnet/minecraft/world/phys/HitResult;)V"}, cancellable=true)
    private void onHit(HitResult result, CallbackInfo callback) {
        EntityHitResult entity;
        Entity entity2;
        if (result.getType() == HitResult.Type.ENTITY && (entity2 = (entity = (EntityHitResult)result).getEntity()) instanceof Lumber) {
            Lumber lumber = (Lumber)entity2;
            float f = 170.0f + this.level().getRandom().nextFloat() * 20.0f;
            this.setDeltaMovement(this.getDeltaMovement().scale(-1.0));
            this.setYRot(this.getYRot() + f);
            this.yRotO += f;
            this.hasImpulse = true;
            this.level().playSound(null, lumber.blockPosition(), SoundEvents.SLIME_BLOCK_PLACE, SoundSource.HOSTILE);
            this.level().gameEvent((Holder)GameEvent.PROJECTILE_SHOOT, result.getLocation(), GameEvent.Context.of((Entity)this, null));
            callback.cancel();
        }
    }
}

