/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixwb.darkhours.networking;

import com.mojang.logging.LogUtils;
import com.phoenixwb.darkhours.client.DHClient;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

public record SetTDMStrength(int strength) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetTDMStrength> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"darkhours", (String)"set_tdm_strength"));
    public static final StreamCodec<ByteBuf, SetTDMStrength> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SetTDMStrength::strength, SetTDMStrength::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class ClientPayloadHandler
    implements IPayloadHandler<SetTDMStrength> {
        public void handle(SetTDMStrength payload, IPayloadContext context) {
            context.enqueueWork(() -> {
                DHClient.strength = payload.strength;
            }).exceptionally(e -> {
                LogUtils.getLogger().info(Component.translatable((String)"darkhours.networking.failed", (Object[])new Object[]{e.getMessage()}).toString());
                return null;
            });
        }
    }
}

