/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixwb.darkhours.networking;

import com.mojang.logging.LogUtils;
import com.phoenixwb.darkhours.effect.MobEffectInit;
import com.phoenixwb.darkhours.item.ItemInit;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

public record UseLumberingEye(int entityId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UseLumberingEye> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"darkhours", (String)"use_lumbering_eye"));
    public static final StreamCodec<ByteBuf, UseLumberingEye> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, UseLumberingEye::entityId, UseLumberingEye::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class ServerPayloadHandler
    implements IPayloadHandler<UseLumberingEye> {
        public void handle(UseLumberingEye payload, IPayloadContext context) {
            context.enqueueWork(() -> {
                block3: {
                    boolean isSurvival;
                    ServerPlayer player;
                    block5: {
                        block4: {
                            player = (ServerPlayer)context.player();
                            LivingEntity entity = (LivingEntity)player.serverLevel().getEntity(payload.entityId);
                            if (entity == null || entity.hasEffect(MobEffectInit.MENTAL_LOAD)) break block3;
                            entity.addEffect(new MobEffectInstance(MobEffectInit.MENTAL_LOAD, 200, 0), (Entity)player);
                            player.level().playSound(null, player.blockPosition(), SoundEvents.CONDUIT_DEACTIVATE, SoundSource.PLAYERS, 1.0f, 0.87f);
                            if (entity instanceof ServerPlayer) {
                                ServerPlayer servplayer = (ServerPlayer)entity;
                                servplayer.playNotifySound(SoundEvents.CAT_HISS, SoundSource.HOSTILE, 1.0f, 0.52f);
                            }
                            boolean bl = isSurvival = !player.isCreative();
                            if (!player.getItemInHand(InteractionHand.MAIN_HAND).is(ItemInit.LUMBERING_EYE)) break block4;
                            player.swing(InteractionHand.MAIN_HAND, true);
                            if (!isSurvival) break block3;
                            player.getItemInHand(InteractionHand.MAIN_HAND).shrink(1);
                            break block3;
                        }
                        if (!player.getItemInHand(InteractionHand.OFF_HAND).is(ItemInit.LUMBERING_EYE)) break block5;
                        player.swing(InteractionHand.OFF_HAND, true);
                        if (!isSurvival) break block3;
                        player.getItemInHand(InteractionHand.OFF_HAND).shrink(1);
                        break block3;
                    }
                    if (isSurvival && player.getInventory().hasAnyMatching(stack -> stack.is(ItemInit.LUMBERING_EYE))) {
                        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                            ItemStack itemstack = player.getInventory().getItem(i);
                            if (!itemstack.is(ItemInit.LUMBERING_EYE)) continue;
                            itemstack.shrink(1);
                            break;
                        }
                    }
                }
            }).exceptionally(e -> {
                LogUtils.getLogger().info(Component.translatable((String)"darkhours.networking.failed", (Object[])new Object[]{e.getMessage()}).toString());
                return null;
            });
        }
    }
}

