/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.INBTSource;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;

public class Corpse
extends Emitter {
    public final IntBounds ageBounds;

    public static Emitter.Properties<?> properties() {
        return (Emitter.Properties)((Object)((SourceBase.Properties)((Object)Emitter.Properties.entity("#hardcoded_age_check", WorldEvents.Alignment.TOP).customFactory(Corpse::new))).carbon(1.0f));
    }

    public Corpse(UnitConfig config, Emitter.Properties<?> props) {
        super(config, props);
        this.ageBounds = config.getIntBounds(this.getClassCategory(), "Age", IntBounds.between((Integer)10, (Integer)60), IntBounds.INTEGER_POSITIVE, "The corpse will produce pollution only when its age is within the specified range (in minutes)");
    }

    public boolean isActive(INBTSource<?> nbtSource) {
        int ageInTicks = nbtSource.serialize().getIntOr("Age", 0);
        int ageInMinutes = (int)GameTime.fromServerTicks((long)ageInTicks).inMinutes();
        return this.ageBounds.encloses(Integer.valueOf(ageInMinutes));
    }
}

