/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.INBTSource;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CreateTFMG {
    public static final String MOD_ID = "tfmg";

    public static Emitter.Properties<?> cokeOven() {
        UnitId id = CreateTFMG.unitIdMetaAll("coke_oven");
        return CreateTFMG.machine(id).relatedBlocks(id.toString());
    }

    public static Emitter.Properties<?> blastFurnace() {
        return CreateTFMG.machine(CreateTFMG.unitIdMetaAll("blast_furnace_output")).relatedBlocks(CreateTFMG.tag("blast_furnace_wall"), CreateTFMG.tag("blast_furnace_support"), CreateTFMG.tag("reinforced_blast_furnace_support"));
    }

    public static Emitter.Properties<?> exhaust() {
        return Emitter.Properties.fuel("", 0.025f).id(CreateTFMG.unitIdMetaAll("exhaust"));
    }

    public static Emitter.Properties<?> flarestack() {
        return Emitter.Properties.fuel("", 0.25f).id(CreateTFMG.unitIdMetaAll("flarestack"));
    }

    public static Emitter.Properties<?> brickSmokestack() {
        return CreateTFMG.smokestack("brick");
    }

    public static Emitter.Properties<?> concreteSmokestack() {
        return CreateTFMG.smokestack("concrete");
    }

    public static Emitter.Properties<?> metalSmokestack() {
        return CreateTFMG.smokestack("metal");
    }

    protected static Emitter.Properties<?> smokestack(String stackType) {
        return Emitter.Properties.fuel("", 0.025f).id(CreateTFMG.unitIdMetaAll(stackType).withNameSuffix("smokestack"));
    }

    public static Emitter.Properties<?> regularEngine() {
        return CreateTFMG.engine("regular").enumIdAsRelatedBlocks();
    }

    public static Emitter.Properties<?> radialEngine() {
        return CreateTFMG.engine("radial").enumIdAsRelatedBlocks();
    }

    public static Emitter.Properties<?> largeEngine() {
        return CreateTFMG.engine("large");
    }

    public static Emitter.Properties<?> simpleLargeEngine() {
        return CreateTFMG.engine("simple_large");
    }

    public static Emitter.Properties<?> turbineEngine() {
        return CreateTFMG.engine("turbine").enumIdAsRelatedBlocks();
    }

    protected static Emitter.Properties<?> engine(String engineType) {
        return CreateTFMG.machine(CreateTFMG.unitIdMetaAll(engineType).withNameSuffix("engine"));
    }

    protected static Emitter.Properties<?> machine(UnitId id) {
        return Emitter.Properties.fuel("").id(id).customFactory(Machine::new);
    }

    protected static String tag(String tagPath) {
        return "#tfmg:" + tagPath;
    }

    protected static UnitId unitIdMetaAll(String name) {
        return UnitId.from((String)MOD_ID, (String)name).withMetaAll();
    }

    public static class Machine
    extends Emitter {
        private Class<?> pumpClass = null;
        private Class<?> pipeClass = null;
        private Class<?> exhaustClass = null;
        private Class<?> smokestackClass = null;
        protected final int maxExhaustPipeLength;

        public Machine(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
            this.maxExhaustPipeLength = UnitConfig.getInt((UnitConfig)config, (String)this.getClassCategory(), (String)"maxExhaustPipeLength", (int)128, (IntBounds)IntBounds.between((Integer)1, (Integer)1024), (String)"The maximum length of the exhaust pipe.\nNote that high values affect performance");
            if (AbstractForgeMod.isLoaded((String)CreateTFMG.MOD_ID)) {
                try {
                    this.pumpClass = Class.forName("com.simibubi.create.content.fluids.pump.PumpBlockEntity");
                    this.pipeClass = Class.forName("com.simibubi.create.content.fluids.pipes.FluidPipeBlockEntity");
                    this.exhaustClass = Class.forName("com.drmangotea.tfmg.content.machinery.misc.exhaust.ExhaustBlockEntity");
                    this.smokestackClass = Class.forName("com.drmangotea.tfmg.content.machinery.misc.smokestack.SmokestackBlockEntity");
                }
                catch (Exception e) {
                    ForgeEndertech.getInstance().getLogger().error(e.toString());
                }
            }
        }

        @Override
        public BlockPos getExhaustPosition(LevelAccessor level, INBTSource<?> nbtSource, BlockPos defaultPos) {
            Object t;
            if (nbtSource.source().isPresent() && (t = nbtSource.source().get()) instanceof BlockEntity) {
                BlockEntity tile = (BlockEntity)t;
                WorldSearch.TileNeighbors neighbors = WorldSearch.TileNeighbors.from((BlockEntity)tile, this.getRelatedBlocks());
                for (BlockPos pos : neighbors.getFound()) {
                    Optional<BlockPos> outlet;
                    BlockState state;
                    if (!this.isActiveExhaustPump(level, pos, state = level.getBlockState(pos), (Set<BlockPos>)neighbors.getChain()) && !this.isConnectedPipe(level, pos, state, (Set<BlockPos>)neighbors.getChain()) || !(outlet = this.getPipeOutlet(level, pos)).isPresent()) continue;
                    return outlet.get();
                }
            }
            return defaultPos;
        }

        protected boolean isActiveExhaustPump(LevelAccessor level, BlockPos pos, BlockState state, Set<BlockPos> tileBlocks) {
            if (this.isActivePump(level, pos)) {
                for (Direction direction : GameWorld.Directions.of().all().toArray()) {
                    if (!tileBlocks.contains(pos.relative(direction))) continue;
                    return this.isFacing(direction.getOpposite(), state);
                }
            }
            return false;
        }

        protected boolean isConnectedPipe(LevelAccessor level, BlockPos pos, BlockState state, Set<BlockPos> tileBlocks) {
            if (this.isPipe((LevelReader)level, pos)) {
                for (Direction direction : GameWorld.Directions.of().all().toArray()) {
                    if (!tileBlocks.contains(pos.relative(direction))) continue;
                    return this.isOpenTowards(direction, state);
                }
            }
            return false;
        }

        protected boolean isActivePump(LevelAccessor level, BlockPos pos) {
            BlockEntity tile = level.getBlockEntity(pos);
            if (this.pumpClass != null && this.pumpClass.isInstance(tile)) {
                CompoundTag compound = INBTSource.of((BlockEntity)tile).serialize();
                float speed = compound.getFloatOr("Speed", 0.0f);
                return speed != 0.0f;
            }
            return false;
        }

        protected boolean isPipe(LevelReader level, BlockPos pos) {
            return this.pipeClass != null && this.pipeClass.isInstance(level.getBlockEntity(pos));
        }

        protected boolean isExhaust(LevelReader level, BlockPos pos) {
            return this.exhaustClass != null && this.exhaustClass.isInstance(level.getBlockEntity(pos));
        }

        protected boolean isSmokestack(LevelReader level, BlockPos pos) {
            return this.smokestackClass != null && this.smokestackClass.isInstance(level.getBlockEntity(pos));
        }

        protected boolean isFacing(Direction direction, BlockState state) {
            return this.stateHasValue(state, "facing", direction.getName());
        }

        protected boolean isOpenTowards(Direction direction, BlockState state) {
            return this.stateHasValue(state, direction.getName(), "true");
        }

        protected BlockPos getTopmostSmokestack(LevelReader level, BlockPos startPos) {
            return GameWorld.Positions.getLastInLine((LevelReader)level, (BlockPos)startPos, this::isSmokestack, (Direction)Direction.UP);
        }

        protected Optional<Direction> getFacingDirection(BlockState state) {
            for (Direction direction : GameWorld.Directions.of().horizontals().toArray()) {
                if (!this.isFacing(direction, state)) continue;
                return Optional.of(direction);
            }
            return Optional.empty();
        }

        protected boolean stateHasValue(BlockState state, String propertyName, String valueName) {
            Property property = state.getBlock().getStateDefinition().getProperty(propertyName);
            if (property != null && state.hasProperty(property)) {
                return property.getValue(valueName).filter(value -> value.equals(state.getValue(property))).isPresent();
            }
            return false;
        }

        protected Optional<BlockPos> getPipeOutlet(LevelAccessor level, BlockPos startPos) {
            WorldSearch.BlockChain pipe = new WorldSearch.BlockChain(level, startPos, this.maxExhaustPipeLength){

                protected Collection<Direction> getDirections() {
                    return GameWorld.Directions.of().all().shuffle().toList();
                }

                private boolean isValidDirection(BlockPos pos) {
                    if (this.lastUsedDirection != null) {
                        BlockPos prevPos = pos.relative(this.lastUsedDirection.getOpposite());
                        BlockState state = this.level.getBlockState(prevPos);
                        return this.isOpenTowards(this.lastUsedDirection, state) || this.isFacing(this.lastUsedDirection, state);
                    }
                    return false;
                }

                protected boolean isValidPath(BlockPos pos) {
                    if (this.lastUsedDirection == null) {
                        return true;
                    }
                    if (this.isValidDirection(pos)) {
                        BlockState state = this.level.getBlockState(pos);
                        if (this.isPipe((LevelReader)this.level, pos) && this.isOpenTowards(this.lastUsedDirection.getOpposite(), state)) {
                            return true;
                        }
                        if (this.isActivePump(this.level, pos) && this.isFacing(this.lastUsedDirection, state)) {
                            return true;
                        }
                    }
                    return false;
                }

                protected boolean isValidBlock(BlockPos pos) {
                    if (this.isValidDirection(pos)) {
                        BlockState state = this.level.getBlockState(pos);
                        if (state.isAir()) {
                            return true;
                        }
                        if (this.isExhaust((LevelReader)this.level, pos) && (this.isFacing(this.lastUsedDirection, state) || this.isFacing(this.lastUsedDirection.getOpposite(), state))) {
                            return true;
                        }
                        if (this.isSmokestack((LevelReader)this.level, pos)) {
                            return true;
                        }
                    }
                    return false;
                }

                protected boolean onValidFound(BlockPos pos) {
                    return true;
                }
            };
            pipe.build();
            return pipe.getFound().stream().findFirst().map(pos -> this.getTopmostSmokestack((LevelReader)level, (BlockPos)pos));
        }

        protected void debuglog(String msg) {
            ForgeEndertech.debugMsg((String)msg);
        }
    }
}

