/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldBounds;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraftforge.common.util.Lazy;

public class McwWindows {
    protected static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    protected static final int MAX_DISTANCE = 8;
    protected static final int MAX_HEIGHT = 4;
    private static final Lazy<Optional<McwWindows>> INSTANCE = AbstractForgeMod.singletonInstance((String)"mcwwindows", McwWindows.class);
    private final Class<?> WindowBarredClass = Class.forName("com.mcwwindows.kikoz.objects.WindowBarred");
    private final Method isOpenMethod = this.WindowBarredClass.getMethod("isOpen", BlockState.class);

    public static Optional<McwWindows> getInstance() {
        return (Optional)INSTANCE.get();
    }

    private McwWindows() throws ClassNotFoundException, NoSuchMethodException {
    }

    protected boolean isOpenWindow(BlockState state) {
        Block block = state.getBlock();
        if (this.WindowBarredClass.isInstance(block)) {
            try {
                return (Boolean)this.isOpenMethod.invoke((Object)block, state);
            }
            catch (Exception e) {
                this.logError(e.toString());
            }
        }
        return false;
    }

    protected boolean pushGas(ServerLevel level, BlockPos windowPos, Direction outputDirection) {
        BlockPos pos;
        for (int distance = 1; distance <= 4 && GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)(pos = windowPos.relative(outputDirection, distance))); ++distance) {
            AbstractGas gas;
            BlockState state = level.getBlockState(pos);
            Block block = state.getBlock();
            if (block instanceof AbstractGas && (gas = (AbstractGas)block).createSpread(level, pos, state).inDirectionForced(outputDirection).inMotionFacing().overLedge().apply()) {
                return true;
            }
            if (state.isFaceSturdy((BlockGetter)level, pos, outputDirection) || state.isFaceSturdy((BlockGetter)level, pos, outputDirection.getOpposite())) break;
        }
        return false;
    }

    public boolean tryDrawGasOut(ServerLevel level, BlockPos windowPos, BlockState windowState, boolean isWindowClosing) {
        WorldBounds searchBounds;
        BlockPos inputPos;
        BlockPos gasPos;
        Direction outputDirection;
        if (!this.isOpenWindow(windowState)) {
            return false;
        }
        if (!windowState.hasProperty(FACING)) {
            return false;
        }
        Direction windowFacing = (Direction)windowState.getValue(FACING);
        Direction direction = outputDirection = isWindowClosing ? windowFacing.getOpposite() : (Direction)this.getOutputDirection(level, windowPos, windowFacing).orElse(null);
        if (outputDirection == null) {
            return false;
        }
        BlockPos outputPos = windowPos.relative(outputDirection);
        if (!this.isValidOutput(level, outputPos)) {
            return false;
        }
        if (isWindowClosing) {
            this.pushGas(level, windowPos, outputDirection);
        }
        if ((gasPos = (BlockPos)this.findGas(level, inputPos = windowPos.relative(outputDirection.getOpposite()), searchBounds = this.getSearchBounds(inputPos, outputDirection)).orElse(null)) == null) {
            return false;
        }
        Block block = level.getBlockState(gasPos).getBlock();
        if (block instanceof AbstractGas) {
            AbstractGas gas = (AbstractGas)block;
            return gas.pump((LevelAccessor)level, outputPos) && gas.spend((LevelAccessor)level, gasPos);
        }
        return false;
    }

    protected void logError(String msg) {
        ForgeEndertech.debugMsg((String)("McwWindows: " + msg));
    }

    protected boolean isValidOutput(ServerLevel level, BlockPos pos) {
        if (GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)pos)) {
            BlockState state = level.getBlockState(pos);
            return state.isAir() || state.getBlock() instanceof AbstractGas;
        }
        return false;
    }

    protected Optional<Direction> getOutputDirection(ServerLevel level, BlockPos windowPos, Direction windowFacing) {
        for (Direction direction : new Direction[]{windowFacing, windowFacing.getOpposite()}) {
            BlockState state;
            BlockPos pos;
            for (int distance = 1; distance <= 8 && GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)(pos = windowPos.relative(direction, distance))) && !(state = level.getBlockState(pos)).isFaceSturdy((BlockGetter)level, pos, direction.getOpposite()) && !state.isFaceSturdy((BlockGetter)level, pos, direction); ++distance) {
                if (!level.canSeeSky(pos)) continue;
                return Optional.of(direction);
            }
        }
        return Optional.empty();
    }

    protected IntBounds getAxisBounds(Direction.Axis axis, BlockPos inputPos, Direction outputDirection) {
        return outputDirection.getAxis() == axis ? IntBounds.between((Integer)inputPos.get(axis), (Integer)inputPos.relative(outputDirection.getOpposite(), 8).get(axis)) : IntBounds.of((Integer)inputPos.get(axis)).extend(Integer.valueOf(4));
    }

    protected WorldBounds getSearchBounds(BlockPos inputPos, Direction outputDirection) {
        IntBounds y = IntBounds.between((Integer)inputPos.getY(), (Integer)(inputPos.getY() + 4));
        IntBounds x = this.getAxisBounds(Direction.Axis.X, inputPos, outputDirection);
        IntBounds z = this.getAxisBounds(Direction.Axis.Z, inputPos, outputDirection);
        return WorldBounds.from((IntBounds)x, (IntBounds)y, (IntBounds)z);
    }

    protected Optional<BlockPos> findGas(ServerLevel level, BlockPos startPos, final WorldBounds searchBounds) {
        WorldSearch.BlockChain chain = new WorldSearch.BlockChain(this, (LevelAccessor)level, startPos, 256){

            protected Collection<Direction> getDirections() {
                return GameWorld.Directions.of().up().horizontals().shuffle().toList();
            }

            protected boolean isOutsideBounds(BlockPos pos) {
                if (!searchBounds.encloses(pos)) {
                    return true;
                }
                return super.isOutsideBounds(pos);
            }

            protected boolean isValidPath(BlockPos pos) {
                if (this.level.isEmptyBlock(pos)) {
                    return true;
                }
                if (this.lastUsedDirection == null) {
                    return true;
                }
                BlockPos last = pos.relative(this.lastUsedDirection.getOpposite());
                return !this.level.getBlockState(last).isFaceSturdy((BlockGetter)this.level, last, this.lastUsedDirection) && !this.level.getBlockState(pos).isFaceSturdy((BlockGetter)this.level, pos, this.lastUsedDirection.getOpposite());
            }

            protected boolean isValidBlock(BlockPos pos) {
                return this.level.getBlockState(pos).getBlock() instanceof AbstractGas;
            }

            protected boolean onValidFound(BlockPos pos) {
                return false;
            }
        };
        chain.build();
        return chain.getFound().stream().findFirst();
    }
}

