/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.config;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.configs.AbstractParsableList;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.ForgeRegistries;

public class LivingEntityImpactList
extends AbstractParsableList {
    protected final List<EntityEffect> effects = new ArrayList<EntityEffect>();
    private final String comment;

    public LivingEntityImpactList(UnitConfig config, String category, String key, String comment) {
        super(config, category, key, new String[0]);
        this.comment = comment;
    }

    public List<EntityEffect> getActiveEffects(Percentage pollution) {
        if (this.effects.isEmpty()) {
            return Collections.emptyList();
        }
        return this.effects.stream().filter(effect -> pollution.isGreaterOrEqualTo((Object)effect.threshold)).collect(Collectors.toList());
    }

    protected String getComment() {
        return this.comment;
    }

    protected void parseConfigValues() {
        this.effects.clear();
        for (String string : this.configValues) {
            List split = this.split(string, "->");
            if (split.size() == 1) {
                split.add(0, "0%");
            }
            try {
                if (split.size() != 2) {
                    throw new Exception();
                }
                Percentage threshold = Percentage.parse((String)((String)split.get(0)));
                UnitId id = UnitId.from((String)((String)split.get(1)));
                if (id.isEmpty()) {
                    throw new Exception();
                }
                ForgeRegistries.MOB_EFFECTS.getHolder(id.toIdentifier()).ifPresent(effect -> this.effects.add(new EntityEffect((Holder<MobEffect>)effect, threshold, EntityEffect.DURATION)));
            }
            catch (Exception e) {
                this.logParsingError(string);
            }
        }
    }

    public static class EntityEffect {
        protected static final CommonTime.Interval DURATION = CommonTime.Interval.seconds((double)5.0);
        public final Holder<MobEffect> effect;
        public final Percentage threshold;
        public final CommonTime.Interval duration;

        public EntityEffect(Holder<MobEffect> effect, Percentage threshold, CommonTime.Interval duration) {
            this.effect = effect;
            this.threshold = threshold;
            this.duration = duration;
        }

        public boolean applyOn(LivingEntity living, Percentage pollution) {
            int amplifier = 0;
            if (this.threshold.isGreaterThan((Object)Percentage.ZERO)) {
                amplifier = Mth.floor((float)(pollution.getValue() / this.threshold.getValue())) - 1;
            }
            if (amplifier < 0) {
                amplifier = 0;
            }
            int ticks = (int)GameTime.inServerTicks((CommonTime.Interval)this.duration);
            return living.addEffect(new MobEffectInstance(this.effect, ticks, amplifier));
        }
    }
}

