/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.UnitsInitWithEnum;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.blocks.Carbon;
import com.endertech.minecraft.mods.adpother.blocks.Dust;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.blocks.Sulfur;
import com.endertech.minecraft.mods.adpother.blocks.UserGas;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.util.Lazy;

public class Pollutants
extends UnitsInitWithEnum<Pollutant<?>, BuiltIn> {
    public Pollutants(AbstractForgeMod mod) {
        super(mod, BuiltIn.class);
    }

    protected ResourceKey<Block> blockId(String name) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (Identifier)this.getMod().getNamespace().identifier(name));
    }

    public Pollutant<?> createDefaultUnitFrom(UnitConfig config, BuiltIn e) {
        e.pollutant = e.factory.create(config, this.blockId(e.getName()));
        return e.pollutant;
    }

    public Pollutant<?> createCustomUnitFrom(UnitConfig config, String name) {
        return new UserGas(config, (AbstractGas.Properties)((Object)((Pollutant.Properties)((Object)((AbstractGas.Properties)((Object)((AbstractGas.Properties)((Object)((AbstractGas.Properties)((Object)AbstractGas.Properties.of(this.blockId(name), MapColor.COLOR_PURPLE).criticalAmount(512))).concentrationAltitude(191))).motionVelocity(0.15f))).absorbtionChance(50))).textColor(ChatFormatting.DARK_PURPLE)));
    }

    public Optional<Pollutant<?>> findByName(String name) {
        return Optional.ofNullable((Lazy)this.mapAll().get(name)).map(Supplier::get);
    }

    public void reloadConfigs() {
        this.getMod().getLogger().error("Unable to reload configs for pollutants because they are registered blocks");
    }

    public static enum BuiltIn implements IForgeEnum
    {
        CARBON(Carbon::new),
        SULFUR(Sulfur::new),
        DUST(Dust::new);

        private final IFactory<?> factory;
        private Pollutant<?> pollutant;

        private BuiltIn(IFactory<?> factory) {
            this.factory = factory;
        }

        public Pollutant<?> get() {
            return this.pollutant;
        }
    }

    static interface IFactory<T extends Pollutant<?>> {
        public T create(UnitConfig var1, ResourceKey<Block> var2);
    }
}

