/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.items;

import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class GasBlockItem
extends BlockItem {
    public GasBlockItem(AbstractGas block, Item.Properties props) {
        super((Block)block, props);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        ServerLevel level;
        Level level2 = entity.level();
        if (level2 instanceof ServerLevel && AbstractGas.spreadIntoWorldInterval.pastIn((Level)(level = (ServerLevel)level2))) {
            this.generateFrom(stack, level, entity.blockPosition());
        }
        entity.setInvulnerable(true);
        return false;
    }

    public int generateFrom(ItemStack stack, ServerLevel level, BlockPos pos) {
        Block block = this.getBlock();
        if (block instanceof AbstractGas) {
            AbstractGas gas = (AbstractGas)block;
            if (!stack.isEmpty() && gas.inAllowableDimension(level) && level.isAreaLoaded(pos, 1)) {
                int count = gas.generateAt((WorldGenLevel)level, pos, stack.getCount(), 1);
                stack.shrink(count);
                return count;
            }
        }
        return 0;
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        Player player;
        if (AbstractGas.spreadIntoWorldInterval.pastIn((Level)level) && entity instanceof Player && !(player = (Player)entity).isSpectator() && !player.isCreative()) {
            this.generateFrom(stack, level, entity.blockPosition());
        }
    }
}

