/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.items;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.DamageableItem;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.client.UsedItemSoundLoop;
import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.endertech.minecraft.mods.adpother.items.VacuumBag;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VacuumTube
extends DamageableItem {
    protected static final FloatBounds SUCK_INTERVAL_BOUNDS_IN_SEC = FloatBounds.between((Float)Float.valueOf(0.25f), (Float)Float.valueOf(1.0f));
    protected final GameTime suckInterval;
    protected final float speed;
    protected final boolean canSuckIntoInventory;

    public VacuumTube(UnitConfig config, Properties<?> props) {
        super(config, props);
        String category = props.name;
        this.speed = UnitConfig.getFloat((UnitConfig)this.getConfig(), (String)category, (String)"speed", (float)props.speed, (FloatBounds)GameBounds.FACTOR.getFloatBounds(), (String)"Defines operating speed for the vacuum cleaner.");
        this.suckInterval = GameTime.seconds((float)SUCK_INTERVAL_BOUNDS_IN_SEC.interpolateDown(this.speed).floatValue());
        this.canSuckIntoInventory = UnitConfig.getBool((UnitConfig)this.getConfig(), (String)category, (String)"canSuckIntoInventory", (boolean)props.suckIntoInventory, (String)"Defines the ability to suck pollution into a player's inventory");
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return InteractionResult.PASS;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            new StartUsingMsg(serverPlayer, hand).sendToAllAround(serverPlayer);
        }
        player.startUsingItem(hand);
        return InteractionResult.CONSUME;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return Integer.MAX_VALUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onUseTick(Level level, LivingEntity living, ItemStack stack, int remainingUseDuration) {
        Player player;
        if (level.isClientSide() && living instanceof Player && (player = (Player)living).isLocalPlayer() && this.suckInterval.pastIn(level)) {
            BlockHitResult result;
            BlockPos pos;
            BlockState state;
            float reachDistance = (float)player.blockInteractionRange();
            Optional hit = ForgeEntity.rayTraceBlockBeingLookedAt((Entity)living, (ClipContext.Block)ClipContext.Block.VISUAL, (ClipContext.Fluid)ClipContext.Fluid.ANY, (float)1.0f, (float)reachDistance);
            if (hit.isPresent() && (state = level.getBlockState(pos = ((BlockHitResult)hit.get()).getBlockPos())).getBlock() instanceof AbstractGas) {
                new BlockSuckInMsg(pos).sendToServer();
                return;
            }
            reachDistance = (float)player.entityInteractionRange();
            Vec3 startVec = living.getEyePosition(1.0f);
            Vec3 lookVec = living.getViewVector(1.0f).scale((double)reachDistance);
            Vec3 endVec = startVec.add(lookVec);
            AABB boundingBox = living.getBoundingBox().expandTowards(lookVec).inflate(1.0, 1.0, 1.0);
            double minDistance = Double.MAX_VALUE;
            Entity closestTarget = null;
            Vec3 closestHit = null;
            for (Entity target : level.getEntitiesOfClass(GasEntity.class, boundingBox)) {
                double distance;
                AABB aabb = target.getBoundingBox().inflate(0.3);
                Vec3 hit2 = aabb.clip(startVec, endVec).orElse(null);
                if (hit2 == null || !((distance = startVec.distanceToSqr(hit2)) < minDistance)) continue;
                closestTarget = target;
                closestHit = hit2;
                minDistance = distance;
            }
            if (closestTarget != null && closestHit != null && ((result = level.clip(new ClipContext(startVec, closestHit, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)living))) == null || result.getType() == HitResult.Type.MISS)) {
                new EntitySuckInMsg((GasEntity)closestTarget).sendToServer();
                return;
            }
        }
    }

    public boolean suckIn(AbstractGas gas, ServerPlayer player) {
        VacuumBag bag;
        ItemStack stack;
        Item item;
        ServerLevel level = player.level();
        boolean suckedIn = false;
        Iterator iterator = ForgeEntity.getEquipmentOn((Entity)player).iterator();
        while (!(!iterator.hasNext() || (item = (stack = (ItemStack)iterator.next()).getItem()) instanceof VacuumBag && (suckedIn = (bag = (VacuumBag)item).fill(stack, (Pollutant<?>)gas, 1) > 0))) {
        }
        if (!suckedIn && (this.canSuckIntoInventory || player.isCreative())) {
            suckedIn = player.getInventory().add(new ItemStack((ItemLike)gas));
        }
        if (!suckedIn) {
            BlockPos toPos = player.blockPosition();
            boolean bl = suckedIn = gas.pump((LevelAccessor)level, toPos) || gas.pump((LevelAccessor)level, toPos.above());
        }
        if (suckedIn) {
            level.playSound(null, player.blockPosition(), SoundEvents.ENDER_DRAGON_FLAP, SoundSource.BLOCKS, 0.1f, this.speed);
        }
        return suckedIn;
    }

    public GameTime getSuckInterval() {
        return this.suckInterval;
    }

    public static class Properties<T extends Properties<T>>
    extends DamageableItem.Properties<T> {
        public float speed;
        public boolean suckIntoInventory;

        public static Properties<?> of(ResourceKey<Item> key) {
            return new Properties<Properties>(Properties.class, key);
        }

        protected Properties(Class<T> selfClass, ResourceKey<Item> key) {
            super(selfClass, key);
        }

        public T speed(float speed) {
            this.speed = speed;
            return (T)((Object)((Properties)this.self));
        }

        public T suckIntoInventory() {
            this.suckIntoInventory = true;
            return (T)((Object)((Properties)this.self));
        }
    }

    public static class StartUsingMsg
    extends ForgeNetMsg<StartUsingMsg> {
        public int playerId;
        public InteractionHand hand;

        public StartUsingMsg() {
        }

        public StartUsingMsg(ServerPlayer player, InteractionHand hand) {
            this.playerId = player.getId();
            this.hand = hand;
        }

        public StartUsingMsg create() {
            return new StartUsingMsg();
        }

        public void handle(Level level, Player player) {
            Entity entity;
            if (level.isClientSide() && (entity = level.getEntity(this.playerId)) instanceof Player) {
                Player playerUsingItem = (Player)entity;
                UsedItemSoundLoop.playVacuumTubeSound(playerUsingItem, this.hand);
            }
        }

        public void sendToAllAround(ServerPlayer player) {
            AdPother.getInstance().getConnection().sendToAllObservingChunk((Object)this, player.level().getChunkAt(player.blockPosition()));
        }
    }

    public static class BlockSuckInMsg
    extends AbstractSuckInMsg<BlockSuckInMsg> {
        public BlockPos pos;

        public BlockSuckInMsg() {
        }

        public BlockSuckInMsg(BlockPos pos) {
            this.pos = pos;
        }

        public BlockSuckInMsg create() {
            return new BlockSuckInMsg();
        }

        @Override
        public void handle(Level world, VacuumTube tube, ServerPlayer player) {
            AbstractGas gas;
            Block block = world.getBlockState(this.pos).getBlock();
            if (block instanceof AbstractGas && tube.suckIn(gas = (AbstractGas)block, player)) {
                gas.spend((LevelAccessor)world, this.pos);
            }
        }
    }

    public static class EntitySuckInMsg
    extends AbstractSuckInMsg<EntitySuckInMsg> {
        public int gasEntityId;

        public EntitySuckInMsg() {
        }

        public EntitySuckInMsg(GasEntity gas) {
            this.gasEntityId = gas.getId();
        }

        public EntitySuckInMsg create() {
            return new EntitySuckInMsg();
        }

        @Override
        public void handle(Level world, VacuumTube tube, ServerPlayer player) {
            GasEntity gasCarrier;
            Optional<AbstractGas> gas;
            Entity entity = world.getEntity(this.gasEntityId);
            if (entity instanceof GasEntity && (gas = (gasCarrier = (GasEntity)entity).getPollutant().filter(p -> p instanceof AbstractGas).map(p -> (AbstractGas)((Object)p))).isPresent() && tube.suckIn(gas.get(), player)) {
                gasCarrier.spend();
            }
        }
    }

    static abstract class AbstractSuckInMsg<T extends AbstractSuckInMsg<T>>
    extends ForgeNetMsg<T> {
        AbstractSuckInMsg() {
        }

        public final void handle(Level level, Player sender) {
            ServerPlayer player;
            Item item;
            if (sender instanceof ServerPlayer && (item = (player = (ServerPlayer)sender).getUseItem().getItem()) instanceof VacuumTube) {
                this.handle(level, (VacuumTube)item, player);
            }
        }

        public abstract void handle(Level var1, VacuumTube var2, ServerPlayer var3);

        public void sendToServer() {
            AdPother.getInstance().getConnection().sendToServer((Object)this);
        }
    }
}

