/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.mixin.minecraft;

import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.extensions.IForgeBlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BlockState.class})
public abstract class BlockStateMixin
extends BlockBehaviour.BlockStateBase
implements IForgeBlockState {
    public BlockStateMixin(Block pOwner, Reference2ObjectArrayMap<Property<?>, Comparable<?>> pValues, MapCodec<BlockState> pPropertiesCodec) {
        super(pOwner, pValues, pPropertiesCodec);
    }

    @Shadow
    protected abstract BlockState asState();

    public void onBlockExploded(ServerLevel level, BlockPos pos, Explosion explosion) {
        WorldEvents.onBlockExploded((Level)level, pos, this.asState(), explosion);
        this.getBlock().onBlockExploded(this.asState(), level, pos, explosion);
    }

    public boolean onCaughtFire(Level level, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        WorldEvents.onBlockBurned(this.asState(), level, pos);
        return this.getBlock().onCaughtFire(this.asState(), level, pos, face, igniter);
    }
}

