/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.forge.units.ITickableUnit;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.blocks.PollutedWater;
import com.endertech.minecraft.mods.adpother.impacts.AbstractPollutionImpacts;
import com.endertech.minecraft.mods.adpother.pollution.ClientSideEntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.PointPollution;
import com.endertech.minecraft.mods.adpother.pollution.PollutionInfo;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.apache.commons.lang3.ObjectUtils;

public class EntityPollution
extends PointPollution
implements ITickableUnit {
    private final Entity entity;
    private final GameTime updateInterval;
    protected boolean exist = true;

    public EntityPollution(Entity entity, GameTime updateInterval, CommonTime.Interval lifeSpan) {
        super(entity.level(), entity.getEyePosition(1.0f), lifeSpan);
        this.entity = entity;
        this.updateInterval = updateInterval;
    }

    public static EntityPollution of(Entity entity) {
        GameTime updateInterval = GameTime.second();
        CommonTime.Interval lifeSpan = CommonTime.Interval.seconds((double)3.0);
        EntityPollution pollution = ForgeEntity.isClientSide((Entity)entity) ? new ClientSideEntityPollution(entity, updateInterval, lifeSpan) : new EntityPollution(entity, updateInterval, lifeSpan);
        pollution.update();
        return pollution;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public boolean exists() {
        return this.exist;
    }

    public GameTime getUpdateInterval() {
        return this.updateInterval;
    }

    public void onUpdate() {
        Entity entity = this.getEntity();
        if (!entity.isAlive()) {
            this.kill();
            return;
        }
        Level level = this.getWorldLevel();
        if (level == null || !level.isAreaLoaded(this.getBlockPos(), 1)) {
            this.kill();
            return;
        }
        if (this.isOutdated()) {
            this.update();
        }
    }

    @Override
    public void update() {
        this.setPosition(this.getEntity().getEyePosition(1.0f));
        super.update();
    }

    public void kill() {
        this.exist = false;
    }

    public Optional<Pollutant<?>> getDominantPollutant(Predicate<Pollutant<?>> filter) {
        Percentage largestInfluence = Percentage.ZERO;
        Pollutant dominant = null;
        for (Pollutant pollutant : AdPother.getInstance().pollutants.streamAll().toList()) {
            Percentage influence;
            if (!filter.test(pollutant) || (influence = this.getInfluenceOf(pollutant)).compareTo(largestInfluence) <= 0) continue;
            largestInfluence = influence;
            dominant = pollutant;
        }
        return Optional.ofNullable(dominant);
    }

    public AbstractPollutionImpacts.ImpactType getImpactType(Pollutant<?> pollutant) {
        if (this.isHeadInPollutant(pollutant)) {
            return AbstractPollutionImpacts.ImpactType.CONTACT;
        }
        if (pollutant.isUnderRainOrStorm((LevelAccessor)this.getWorldLevel(), this.getBlockPos())) {
            return AbstractPollutionImpacts.ImpactType.RAIN;
        }
        return AbstractPollutionImpacts.ImpactType.AIR;
    }

    public boolean isHeadInPollutant(Pollutant<?> pollutant) {
        if (pollutant.isSamePollutant(this.getState())) {
            return true;
        }
        boolean isPollutedWater = PollutedWater.isPollutedWith(pollutant, (BlockGetter)this.getWorldLevel(), this.getBlockPos(), this.getState());
        return isPollutedWater && this.entity.isEyeInFluid(FluidTags.WATER);
    }

    public int getDamageFrom(Pollutant<?> pollutant) {
        Percentage influence = this.getInfluenceOf(pollutant);
        float preciseDamage = influence.toFraction() * (float)pollutant.getPollutionCapacity();
        int damage = Math.round(preciseDamage);
        if (this.getImpactType(pollutant) == AbstractPollutionImpacts.ImpactType.CONTACT) {
            damage = Math.max(damage, 1);
        }
        return damage;
    }

    public Stream<Pollutant<?>> getPollutants() {
        return this.getInfos().map(PollutionInfo::getPollutant);
    }

    public Percentage getInfluenceOf(Pollutant<?> pollutant) {
        Percentage influence = this.getInfoFor(pollutant).map(info -> info.getPercentageIn(this.getBiomeId())).orElse(Percentage.ZERO);
        if (this.getImpactType(pollutant) == AbstractPollutionImpacts.ImpactType.CONTACT) {
            int amount = pollutant.getCarriedPollutionAmount(this.getState());
            Percentage directInfluence = Percentage.from((int)amount, (int)pollutant.getPollutionCapacity());
            Percentage airShortage = ForgeEntity.getAirShortage((Entity)this.entity);
            return (Percentage)ObjectUtils.max((Comparable[])new Percentage[]{influence, directInfluence, airShortage});
        }
        return influence;
    }

    @Override
    public void readFrom(CompoundTag compound) {
        super.readFrom(compound);
    }

    @Override
    public void writeTo(CompoundTag compound) {
        super.writeTo(compound);
    }

    public static class NetMsg
    extends ForgeNetMsg<NetMsg> {
        public int entityId;
        public CompoundTag compound;

        public NetMsg() {
        }

        public NetMsg(EntityPollution pollution) {
            this.entityId = pollution.entity.getId();
            this.compound = new CompoundTag();
            pollution.writeTo(this.compound);
        }

        public NetMsg create() {
            return new NetMsg();
        }

        public void handle(Level level, Player player) {
            Entity entity = level.getEntity(this.entityId);
            if (entity != null) {
                EntityPollution pollution = WorldData.getEntityPollution(entity);
                pollution.readFrom(this.compound);
                pollution.update();
            }
        }

        public void sendToAllAround(ServerLevelAccessor world, BlockPos pos, int radius) {
            AdPother.getInstance().getConnection().sendToAllAround((Object)this, world, pos, radius);
        }
    }
}

