/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.forge.math.AABBHelper;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.ChunkLoc;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.entities.PurifiedAir;
import com.endertech.minecraft.mods.adpother.pollution.AbstractPollution;
import com.endertech.minecraft.mods.adpother.pollution.ChunkPollution;
import com.endertech.minecraft.mods.adpother.pollution.PollutionInfo;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class PointPollution
extends AbstractPollution {
    private final Level level;
    private BiomeId biome = BiomeId.from((ResourceKey)Biomes.PLAINS);
    private Vec3 position = Vec3.ZERO;
    private BlockPos blockpos = BlockPos.ZERO;
    private BlockState state = Blocks.AIR.defaultBlockState();
    protected CommonTime.Interval lifeSpan;
    protected CommonTime.Stamp lastUpdate;

    public PointPollution(Level level, Vec3 position, CommonTime.Interval lifeSpan) {
        this.level = level;
        this.lifeSpan = lifeSpan;
        this.setPosition(position);
    }

    protected void setPosition(Vec3 position) {
        ServerLevel serverLevel;
        if (position.equals((Object)this.position)) {
            return;
        }
        this.position = position;
        this.blockpos = BlockPos.containing((Position)position);
        this.biome = BiomeId.from((LevelAccessor)this.level, (BlockPos)this.blockpos);
        Level level = this.level;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).isPositionEntityTicking(this.blockpos)) {
            this.state = this.level.getBlockState(this.blockpos);
        }
    }

    public boolean isOutdated() {
        return this.lastUpdate == null || CommonTime.Interval.passedFrom((CommonTime.Stamp)this.lastUpdate).moreThan(this.lifeSpan);
    }

    public BlockState getState() {
        return this.state;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public BlockPos getBlockPos() {
        return this.blockpos;
    }

    public Level getWorldLevel() {
        return this.level;
    }

    public BiomeId getBiomeId() {
        return this.biome;
    }

    public void update() {
        ServerLevel serverLevel;
        ServerLevel level;
        this.lastUpdate = CommonTime.Stamp.now();
        Level level2 = this.getWorldLevel();
        ServerLevel serverLevel2 = level = level2 instanceof ServerLevel ? (serverLevel = (ServerLevel)level2) : null;
        if (level == null) {
            return;
        }
        if (!level.isPositionEntityTicking(this.getBlockPos())) {
            return;
        }
        ChunkPos center = new ChunkPos(this.getBlockPos());
        FloatBounds horizDistanceBounds = FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(24.0f));
        FloatBounds vertDistanceBounds = FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(10.0f));
        ArrayList<ChunkPollution> chunksPollution = new ArrayList<ChunkPollution>();
        for (ChunkPos chunkPos : GameWorld.Positions.getAroundHoriz((ChunkPos)center, (boolean)true, (ChunkPos[])new ChunkPos[]{center})) {
            if (!level.isPositionEntityTicking(chunkPos.getWorldPosition())) continue;
            ChunkPollution pollution = WorldData.getChunkPollution((Level)level, ChunkLoc.from((Level)level, (ChunkPos)chunkPos));
            chunksPollution.add(pollution);
        }
        List cleanAirSources = level.getEntitiesOfClass(PurifiedAir.class, AABBHelper.BLOCK.move(this.getPosition()).inflate(32.0));
        this.infoForPollutant.clear();
        for (Pollutant pollutant : AdPother.getInstance().pollutants.streamAll().toList()) {
            float cleanAirFactor;
            int cumulativeAmount = chunksPollution.stream().mapToInt(chunkPollution -> {
                int amount = chunkPollution.getInfoFor(pollutant).map(PollutionInfo::getQuantity).orElse(0);
                if (amount > 0) {
                    ChunkBounds chunkBounds = chunkPollution.getLocation().getBounds((LevelHeightAccessor)level);
                    Vec3 chunkCenter = GameWorld.getBlockCenter((BlockPos)BlockPos.containing((double)chunkBounds.getX().center().intValue(), (double)this.getPosition().y(), (double)chunkBounds.getZ().center().intValue())).toVector3d();
                    float distance = (float)this.getPosition().distanceTo(chunkCenter);
                    amount = this.interpolateAmount(amount, horizDistanceBounds, distance);
                }
                return amount;
            }).sum();
            if (cumulativeAmount > 0) {
                IntBounds altitude = WorldData.altitudeBounds;
                float y = (float)this.getPosition().y;
                float distance = 0.0f;
                if (y > (float)altitude.getMax().intValue()) {
                    distance = y - (float)altitude.getMax().intValue();
                } else if (y < (float)altitude.getMin().intValue()) {
                    distance = (float)altitude.getMin().intValue() - y;
                }
                if (distance > 0.0f) {
                    cumulativeAmount = this.interpolateAmount(cumulativeAmount, vertDistanceBounds, distance);
                }
            }
            if (cumulativeAmount > 0 && (cleanAirFactor = (float)cleanAirSources.stream().filter(air -> air.isAlive() && air.getPollutant().isPresent() && air.getPollutant().get() == pollutant).mapToDouble(air -> air.getConcentrationAt(this.position).toFraction()).sum()) > 0.0f) {
                cumulativeAmount -= Math.round((float)cumulativeAmount * cleanAirFactor);
            }
            if (cumulativeAmount <= 0 && !pollutant.isSamePollutant(this.state)) continue;
            this.getOrCreateInfoFor(pollutant).setQuantity(cumulativeAmount);
        }
    }

    private int interpolateAmount(int baseAmount, FloatBounds distanceBounds, float distance) {
        float factor = distanceBounds.interpolationFactor(Float.valueOf(distance));
        return IntBounds.between((Integer)0, (Integer)baseAmount).interpolateDown(factor);
    }

    @Override
    public void readFrom(CompoundTag compound) {
        super.readFrom(compound);
        this.lifeSpan = CommonTime.Interval.seconds((double)compound.getDoubleOr("lifeSpan", 0.0));
        this.setPosition(TagHelper.getVect3d((CompoundTag)compound, (String)"Position").toVector3d());
    }

    @Override
    public void writeTo(CompoundTag compound) {
        super.writeTo(compound);
        TagHelper.putVect3d((CompoundTag)compound, (String)"Position", (Vect3d)Vect3d.from((Vec3)this.position));
        compound.putDouble("lifeSpan", this.lifeSpan.inSeconds());
    }
}

