/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.renderers;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.client.renderer.GlassMeterIndicatorsRenderer;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.items.Aerometer;
import com.endertech.minecraft.mods.adpother.pollution.ClientSideEntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.serialization.MapCodec;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class AerometerIndicatorsRenderer
extends GlassMeterIndicatorsRenderer<Entity> {
    static final ColorARGB COLOR_RED = ColorARGB.from((Color)Color.RED);
    public static final MapCodec<SpecialModelRenderer.Unbaked> CODEC = MapCodec.unit((Object)new SpecialModelRenderer.Unbaked(){

        @Nullable
        public SpecialModelRenderer<?> bake(SpecialModelRenderer.BakingContext context) {
            return new AerometerIndicatorsRenderer(context.entityModelSet());
        }

        public MapCodec<? extends SpecialModelRenderer.Unbaked> type() {
            return CODEC;
        }
    });

    public AerometerIndicatorsRenderer(EntityModelSet modelSet) {
        super(modelSet);
    }

    @Nullable
    public Entity extractArgument(ItemStack stack) {
        return Aerometer.getCarrierFor(stack).orElse(null);
    }

    public void submit(@Nullable Entity carrier, ItemDisplayContext displayContext, PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, int packedOverlay, boolean hasFoil, int outlineColor) {
        ClientSideEntityPollution cp;
        if (carrier == null) {
            return;
        }
        EntityPollution pollution = WorldData.getEntityPollution(carrier);
        RenderType renderType = this.getRenderType();
        double needleOffset = 0.001;
        double offset = 0.001;
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.translate(0.0f, 0.0f, -0.04f);
        poseStack.translate(0.0, 0.0, offset);
        for (Pollutant<?> pollutant : pollution.getPollutants().toList()) {
            float factor = pollution.getInfluenceOf(pollutant).toFraction();
            ColorARGB color = pollutant.getColor();
            poseStack.translate(0.0, 0.0, offset);
            poseStack.pushPose();
            nodeCollector.submitCustomGeometry(poseStack, renderType, (pose, consumer) -> this.renderNeedle(consumer, pose, color, factor));
            poseStack.popPose();
            poseStack.translate(0.0, 0.0, -offset);
            offset += 0.001;
        }
        if (pollution instanceof ClientSideEntityPollution && (cp = (ClientSideEntityPollution)pollution).getGasDetection().getResult().explosionRisk()) {
            nodeCollector.submitCustomGeometry(poseStack, renderType, (pose, consumer) -> this.renderExplosionRiskIndicator(consumer, pose, COLOR_RED));
        }
        poseStack.popPose();
    }

    public void getExtents(Consumer<Vector3fc> consumer) {
    }

    protected void renderExplosionRiskIndicator(VertexConsumer consumer, PoseStack.Pose pose, ColorARGB color) {
        float size = 0.3f;
        AerometerIndicatorsRenderer.addVertex((VertexConsumer)consumer, (PoseStack.Pose)pose, (ColorARGB)color, (float)0.0f, (float)0.3f, (float)0.5f, (float)0.0f);
        AerometerIndicatorsRenderer.addVertex((VertexConsumer)consumer, (PoseStack.Pose)pose, (ColorARGB)color, (float)-0.3f, (float)0.15f, (float)0.0f, (float)1.0f);
        AerometerIndicatorsRenderer.addVertex((VertexConsumer)consumer, (PoseStack.Pose)pose, (ColorARGB)color, (float)0.3f, (float)0.15f, (float)1.0f, (float)1.0f);
        AerometerIndicatorsRenderer.addVertex((VertexConsumer)consumer, (PoseStack.Pose)pose, (ColorARGB)color, (float)0.3f, (float)0.15f, (float)1.0f, (float)1.0f);
    }

    protected void renderNeedle(VertexConsumer consumer, PoseStack.Pose pose, ColorARGB color, float factor) {
        CommonMath.Angle angle = CommonMath.Angle.fromDegrees((double)(FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(180.0f)).interpolateDown(factor).floatValue() - 90.0f));
        pose.rotate((Quaternionfc)new Quaternionf().rotateZ((float)angle.getRadians()));
        float sW = 0.05f;
        float sL = 0.35f;
        AerometerIndicatorsRenderer.addVertex((VertexConsumer)consumer, (PoseStack.Pose)pose, (ColorARGB)color, (float)-0.05f, (float)-0.07f, (float)0.0f, (float)0.0f);
        AerometerIndicatorsRenderer.addVertex((VertexConsumer)consumer, (PoseStack.Pose)pose, (ColorARGB)color, (float)0.05f, (float)-0.07f, (float)1.0f, (float)0.0f);
        AerometerIndicatorsRenderer.addVertex((VertexConsumer)consumer, (PoseStack.Pose)pose, (ColorARGB)color, (float)0.05f, (float)0.35f, (float)1.0f, (float)1.0f);
        AerometerIndicatorsRenderer.addVertex((VertexConsumer)consumer, (PoseStack.Pose)pose, (ColorARGB)color, (float)-0.05f, (float)0.35f, (float)0.0f, (float)1.0f);
    }
}

