/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.renderers;

import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.math.RandomWrapper;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.PollutionParticle;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.awt.Color;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="adpother", value={Dist.CLIENT})
public final class Smog {
    public static ForgeConfigSpec.ConfigValue<Boolean> enabled;
    public static ForgeConfigSpec.ConfigValue<Boolean> colored;
    public static ForgeConfigSpec.ConfigValue<Boolean> particles;
    public static ForgeConfigSpec.ConfigValue<Double> density;
    private static final CommonTime.Interval updateInterval;
    private static CommonTime.Stamp lastUpdate;
    private static ColorARGB currentColor;
    private static ColorARGB pollutionColor;
    private static float currentDensity;
    private static float targetDensity;

    @SubscribeEvent
    public static boolean onRenderFog(ViewportEvent.RenderFog event) {
        if (!((Boolean)enabled.get()).booleanValue()) {
            return false;
        }
        if (CommonTime.Interval.passedFrom((CommonTime.Stamp)lastUpdate).moreThan(updateInterval)) {
            Entity entity = event.getCamera().entity();
            EntityPollution pollution = WorldData.getEntityPollution(entity);
            targetDensity = (float)pollution.getPollutants().map(pollution::getInfluenceOf).mapToDouble(Percentage::toFraction).sum();
            pollutionColor = ColorARGB.blend(pollution.getPollutants().collect(Collectors.toMap(Pollutant::getColor, p -> (int)pollution.getInfluenceOf((Pollutant<?>)((Object)p)).getValue())));
            lastUpdate = CommonTime.Stamp.now();
        }
        float changingStep = 3.0E-4f;
        float delta = targetDensity - currentDensity;
        currentDensity = Math.abs(delta) >= Math.abs(changingStep) ? (currentDensity += changingStep * Math.signum(delta)) : targetDensity;
        boolean cancelEvent = false;
        if (Smog.updateFogDistance(-8.0f, 1.0f, () -> ((ViewportEvent.RenderFog)event).getNearPlaneDistance(), arg_0 -> ((ViewportEvent.RenderFog)event).setNearPlaneDistance(arg_0))) {
            cancelEvent = true;
        }
        if (Smog.updateFogDistance(8.0f, 1.0f, () -> ((ViewportEvent.RenderFog)event).getFarPlaneDistance(), arg_0 -> ((ViewportEvent.RenderFog)event).setFarPlaneDistance(arg_0))) {
            cancelEvent = true;
        }
        return cancelEvent;
    }

    @SubscribeEvent
    public static void onComputeFogColor(ViewportEvent.ComputeFogColor event) {
        ColorARGB targetColor;
        if (!((Boolean)enabled.get()).booleanValue() || !((Boolean)colored.get()).booleanValue()) {
            return;
        }
        FloatBounds range = FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0f));
        ColorARGB vanillaColor = ColorARGB.from((Color)new Color(range.enclose(Float.valueOf(event.getRed())).floatValue(), range.enclose(Float.valueOf(event.getGreen())).floatValue(), range.enclose(Float.valueOf(event.getBlue())).floatValue()));
        ColorARGB colorARGB = targetColor = pollutionColor.equals((Object)ColorARGB.DEFAULT) || pollutionColor.equals((Object)vanillaColor) ? vanillaColor : ColorARGB.blend(Map.of(vanillaColor, 100, pollutionColor, (int)(currentDensity * 100.0f)));
        if (!currentColor.equals((Object)targetColor)) {
            currentColor = Smog.isInWater() ? targetColor : currentColor.approxTo(targetColor, 0.05f);
        }
        event.setRed(currentColor.getRed().toFloat());
        event.setGreen(currentColor.getGreen().toFloat());
        event.setBlue(currentColor.getBlue().toFloat());
    }

    public static final void onAmbientParticleTick(ClientLevel level, RandomSource randomSource, BlockPos pos) {
        if (!((Boolean)particles.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        EntityPollution pollution = WorldData.getEntityPollution((Entity)player);
        if (pollution.isEmpty()) {
            return;
        }
        Random random = RandomWrapper.of((RandomSource)randomSource);
        Vect3d motion = GameWorld.getWindAt((Level)level, (BlockPos)pos).getMotion();
        int influenceTotal = (int)pollution.getPollutants().map(pollution::getInfluenceOf).mapToDouble(Percentage::getValue).sum();
        for (Pollutant<?> pollutant : pollution.getPollutants().toList()) {
            Percentage chance;
            Percentage influence = pollution.getInfluenceOf(pollutant);
            Percentage contribution = Percentage.from((int)((int)influence.getValue()), (int)influenceTotal);
            if (influence.isGreaterThan((Object)Percentage.HUNDRED)) {
                influence = Percentage.HUNDRED;
            }
            if (!(chance = influence.multiply(contribution.toFraction() * 0.15f)).takeChance(random)) continue;
            PollutionParticle.Options options = new PollutionParticle.Options(influence, pollutant);
            level.addAlwaysVisibleParticle((ParticleOptions)options, (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + random.nextDouble(), motion.x, motion.y, motion.z);
        }
    }

    private static boolean updateFogDistance(float min, float pow, Supplier<Float> getter, Consumer<Float> setter) {
        float factor;
        float current = getter.get().floatValue();
        FloatBounds bounds = FloatBounds.between((Float)Float.valueOf(min), (Float)Float.valueOf(current));
        float target = bounds.interpolateDown(factor = (float)(Math.pow(currentDensity, pow) * (Double)density.get())).floatValue();
        if (target < current) {
            setter.accept(Float.valueOf(target));
            return true;
        }
        return false;
    }

    private static boolean isInWater() {
        LocalPlayer player = Minecraft.getInstance().player;
        return player != null && player.isInWater();
    }

    static {
        updateInterval = GameTime.quaterSecond().getInterval();
        lastUpdate = CommonTime.Stamp.now();
        currentColor = ColorARGB.DEFAULT;
        pollutionColor = ColorARGB.DEFAULT;
        currentDensity = 0.0f;
        targetDensity = 0.0f;
    }
}

