/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.client.ItemModel;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.Dependencies;
import com.endertech.minecraft.forge.data.SuctionHoppers;
import com.endertech.minecraft.forge.items.DamageableItem;
import com.endertech.minecraft.forge.items.GlassMeter;
import com.endertech.minecraft.forge.network.TileSharedDataMsg;
import com.endertech.minecraft.forge.tiles.RepaintableBlockTile;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.Wind;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.SystemUtils;

@Mod(value="forgeendertech")
public class ForgeEndertech
extends AbstractForgeMod {
    public static final String ID = "forgeendertech";
    private static final boolean DEVELOPER_ENVIRONMENT = !FMLEnvironment.production && "forgeendertech".indexOf(SystemUtils.getUserHome().getName().toLowerCase()) == 5;
    private static ForgeEndertech instance;
    static ForgeConfigSpec.ConfigValue<Boolean> debug;

    public ForgeEndertech(FMLJavaModLoadingContext context) {
        super(context);
        instance = this;
        Wind.initDefaultWind(this);
        this.registerCommonConfig();
        PlayerInteractEvent.LeftClickBlock.BUS.addListener(GlassMeter::onLeftClickBlock);
        PlayerInteractEvent.RightClickBlock.BUS.addListener((byte)-127, RepaintableBlockTile::onPlayerRightClickBlock);
        AnvilUpdateEvent.BUS.addListener(DamageableItem::onAnvilUpdate);
    }

    public static ForgeEndertech getInstance() {
        return instance;
    }

    public static boolean isDebugMode() {
        return (Boolean)debug.get();
    }

    public static void debugMsg(String msg) {
        if (ForgeEndertech.isDebugMode()) {
            ForgeEndertech.getInstance().getLogger().debug(msg);
        }
    }

    public static void developMsg(String msg) {
        if (DEVELOPER_ENVIRONMENT) {
            ForgeEndertech.debugMsg(msg);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public AbstractForgeMod.RequiredSide getRequiredSide() {
        return AbstractForgeMod.RequiredSide.SERVER;
    }

    @Override
    public void commonInit() {
        this.registerNetMessage(TileSharedDataMsg::new);
        this.registerNetMessage(Wind.WindMsg::new);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        Dependencies.checkIntegrityOnce();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterItemModelProperties(ItemModel.Properties<?> props) {
    }

    @Override
    protected void serverAboutToStart(MinecraftServer server) {
        Wind.initDefaultWind(this);
    }

    @Override
    public void commonConfigInit(AbstractForgeMod.ConfigValueBuilder value) {
        value.push("Painting");
        RepaintableBlockTile.requiresWaterBucket = value.comment("Whether a bucket of water is required to be in the player's inventory in order to paint").define("requiresWaterBucket", true);
        RepaintableBlockTile.requiresDye = value.comment("Whether a dye is required to be in the player's inventory in order to paint").define("requiresDye", true);
        value.pop();
        value.push("SmokeContainers");
        GameWorld.SmokeContainers.maxVentPipeLength = value.comment("Maximum length of the vent pipe for smoke or gas transmition").defineInRange("maxVentPipeLength", 32, IntBounds.between(1, 64));
        GameWorld.SmokeContainers.ventReachDistance = value.comment("Maximum distance from vent to the gas block to be sucked in").defineInRange("ventReachDistance", 4, IntBounds.between(1, 16));
        GameWorld.SmokeContainers.maxBlocksInMultiblock = value.comment("Maximum amount of blocks that will be checked when searching for multiblock boundaries").defineInRange("maxBlocksInMultiblock", 81, IntBounds.between(1, 512));
        GameWorld.SmokeContainers.pumpedChimneyAirflow = value.comment("Strength of the airflow created in the chimney by a connected exhaust pump").defineInRange("pumpedChimneyAirflow", 1, IntBounds.between(0, 10));
        GameWorld.SmokeContainers.suctionHoppers = new SuctionHoppers(value, "List of hoppers in the following format: blockID, suctionRange\nWhere suctionRange is the radius of the cylindrical area above the hopper within which the pollution will be sucked in.\nThe height of this area is always 3 blocks.\nRange: 1 ~ 64", new String[]{"minecraft:hopper, 8", "brickhopper:brick_hopper, 6", "goldenhopper:golden_hopper, 12", "littlelogistics:rapid_hopper, 12"});
        value.pop();
        debug = value.comment("Enable/Disable debug mode").define("debug", false);
    }

    @Override
    public void commonPostInit() {
        GameWorld.SmokeContainers.suctionHoppers.loadData();
    }

    @Override
    public void configUpdated(ModConfig config) {
        GameWorld.SmokeContainers.suctionHoppers.loadData();
    }

    @Override
    public void tagsUpdated() {
        GameWorld.SmokeContainers.suctionHoppers.loadData();
    }
}

