/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.math;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.math.Vect3d;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class GameMath {
    public static final float PI = (float)Math.PI;

    public static float cos(float degrees) {
        return Mth.cos((double)GameMath.getRadians(degrees));
    }

    public static float sin(float degrees) {
        return Mth.sin((double)GameMath.getRadians(degrees));
    }

    public static boolean VectorsAreEqual(Vec3 vec1, Vec3 vec2) {
        if (vec1 != null && vec2 != null) {
            return vec1.x == vec2.x && vec1.y == vec2.y && vec1.z == vec2.z;
        }
        return vec1 == vec2;
    }

    public static Vect3d getBBCenter(AABB bb) {
        if (bb != null) {
            return Vect3d.from(CommonMath.getAverage(bb.minX, bb.maxX), CommonMath.getAverage(bb.minY, bb.maxY), CommonMath.getAverage(bb.minZ, bb.maxZ));
        }
        return Vect3d.ZERO;
    }

    public static float getDegrees(float radians) {
        return radians * 180.0f / (float)Math.PI;
    }

    public static float getRadians(float degrees) {
        return degrees * (float)Math.PI / 180.0f;
    }

    public static float arcTan(double y, double x) {
        return GameMath.getDegrees((float)Math.atan2(y, x));
    }

    public static float roundTo(float value, int powerOf10) {
        double pow = Math.pow(10.0, -powerOf10);
        double mult = (double)value * pow;
        int round = Math.round((float)mult);
        return (float)((double)round / pow);
    }

    public static boolean isNaN(Vec3 vec) {
        return Double.isNaN(vec.x) || Double.isNaN(vec.y) || Double.isNaN(vec.z);
    }
}

