/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.tiles;

import com.endertech.minecraft.forge.tiles.ForgeTile;
import com.endertech.minecraft.forge.tiles.TileInventory;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.wrapper.RangedWrapper;

public abstract class ForgeTileWithInventory
extends ForgeTile
implements MenuProvider {
    protected final LazyOptional<TileInventory> inventoryHolder = LazyOptional.of(() -> this.getTileInventory());
    protected final LazyOptional<RangedWrapper> inputHolder = LazyOptional.of(() -> this.createInput(this.getTileInventory()));
    protected final LazyOptional<RangedWrapper> outputHolder = LazyOptional.of(() -> this.createOutput(this.getTileInventory()));

    public ForgeTileWithInventory(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public abstract TileInventory getTileInventory();

    protected abstract RangedWrapper createInput(TileInventory var1);

    protected abstract RangedWrapper createOutput(TileInventory var1);

    @Nullable
    protected abstract AbstractContainerMenu createContainer(int var1, Player var2, Inventory var3, TileInventory var4);

    @Nullable
    public final AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return this.createContainer(id, player, playerInventory, this.getTileInventory());
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        input.read("inv", CompoundTag.CODEC).ifPresent(tag -> this.getTileInventory().deserializeNBT(input.lookup(), (CompoundTag)tag));
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        Optional.ofNullable(this.level).map(Level::registryAccess).ifPresent(reg -> output.store("inv", CompoundTag.CODEC, (Object)this.getTileInventory().serializeNBT((HolderLookup.Provider)reg)));
    }

    public boolean canInteractWith(Player player) {
        return !this.isRemoved() && this.getBlockPos().distSqr((Vec3i)player.blockPosition()) <= 64.0;
    }

    public void setRemoved() {
        super.setRemoved();
        this.inventoryHolder.invalidate();
        this.inputHolder.invalidate();
        this.outputHolder.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryHolder.cast();
        }
        return super.getCapability(cap, side);
    }
}

