/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.UnitsInit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

public class RegistryObjectsInit<O>
extends UnitsInit<O> {
    protected final ResourceKey<Registry<O>> registryKey;
    protected final DeferredRegister<O> deferredRegister;

    public RegistryObjectsInit(AbstractForgeMod mod, IForgeRegistry<O> registry) {
        this(mod, registry.getRegistryKey());
    }

    protected RegistryObjectsInit(AbstractForgeMod mod, ResourceKey<Registry<O>> registryKey) {
        super(mod);
        this.registryKey = registryKey;
        this.deferredRegister = DeferredRegister.create(registryKey, (String)mod.getId());
        this.deferredRegister.register(mod.getBusGroup());
        RegisterEvent.getBus((BusGroup)mod.getBusGroup()).addListener(event -> {
            if (registryKey.equals((Object)event.getRegistryKey())) {
                this.onRegistration((RegisterEvent)event);
            }
        });
    }

    protected ResourceKey<O> resourceKey(String name) {
        return ResourceKey.create(this.registryKey, (Identifier)this.getMod().getNamespace().identifier(name));
    }

    public <U extends O> RegistryObject<U> register(String name, Supplier<U> supplier) {
        Lazy<U> unit = this.addUnit(name, supplier);
        return this.deferredRegister.register(name, unit);
    }

    public <U extends O> RegistryObject<U> register(String name, Function<ResourceKey<O>, U> resourceKeyToUnit) {
        return this.register(name, () -> resourceKeyToUnit.apply(this.resourceKey(name)));
    }

    public <U extends O, RO> RegistryObject<U> register(RegistryObject<RO> registryObject, BiFunction<ResourceKey<O>, RO, U> keyAndObjectToUnit) {
        String name = registryObject.getId().getPath();
        return this.register(name, () -> keyAndObjectToUnit.apply(this.resourceKey(name), registryObject.get()));
    }

    protected void onRegistration(RegisterEvent event) {
    }
}

